/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.OrganismImpl;
import psidev.psi.mi.tab.model.UnmodifiableOrganism;
import psidev.psi.mi.tab.model.isCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganismFactory
implements isCache {
    public static final Log log = LogFactory.getLog(OrganismFactory.class);
    private static OrganismFactory ourInstance = new OrganismFactory();
    private boolean cacheEnabled = false;
    final Map<String, Organism> cache = new HashMap<String, Organism>();

    public static OrganismFactory getInstance() {
        return ourInstance;
    }

    private OrganismFactory() {
    }

    public Organism build(int taxid, String name) {
        if (name == null) {
            throw new IllegalArgumentException("You must give a non null name");
        }
        name = name.trim();
        Organism o = null;
        if (this.cacheEnabled) {
            String key = taxid + name;
            o = this.cache.get(key);
            if (o == null) {
                o = new UnmodifiableOrganism(new OrganismImpl(taxid, name));
                this.cache.put(key, o);
            }
        } else {
            o = new OrganismImpl(taxid, name);
        }
        return o;
    }

    public Organism build(int taxid) {
        Organism o = null;
        if (this.cacheEnabled) {
            String key = String.valueOf(taxid);
            o = this.cache.get(key);
            if (o == null) {
                o = new UnmodifiableOrganism(new OrganismImpl(taxid));
                this.cache.put(key, o);
            }
        } else {
            o = new OrganismImpl(taxid);
        }
        return o;
    }

    public Organism build(Collection<CrossReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException("You must give a non null CrossReference collection");
        }
        Organism o = null;
        if (this.cacheEnabled) {
            ArrayList<CrossReference> orderedRefs = new ArrayList<CrossReference>(refs);
            Collections.sort(orderedRefs, new Comparator<CrossReference>(){

                @Override
                public int compare(CrossReference o1, CrossReference o2) {
                    return o1.getIdentifier().compareTo(o2.getIdentifier());
                }
            });
            StringBuilder sb = new StringBuilder();
            for (CrossReference cr : orderedRefs) {
                sb.append(cr.getIdentifier()).append('.');
            }
            String key = sb.toString();
            o = this.cache.get(key);
            if (o == null) {
                o = new UnmodifiableOrganism(new OrganismImpl(refs));
                this.cache.put(key, o);
            }
        } else {
            o = new OrganismImpl(refs);
        }
        return o;
    }

    @Override
    public void resetCache() {
        this.cache.clear();
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public void setCacheEnabled(boolean enabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting InteractionDetectionMethod pooling: " + (enabled ? "on" : "off")));
        }
        this.cacheEnabled = enabled;
    }
}

