/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.InteractionDetectionMethodConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractionTypeConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.NullCrossReference;
import psidev.psi.mi.tab.converter.xml2tab.PublicationConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.AuthorImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Bibref;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionDetectionMethod;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Unit;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionConverter<T extends BinaryInteraction<?>> {
    private static final Log log = LogFactory.getLog(InteractionConverter.class);
    private InteractionTypeConverter itConverter = new InteractionTypeConverter();
    private InteractionDetectionMethodConverter idmConverter = new InteractionDetectionMethodConverter();
    private PublicationConverter pubConverter = new PublicationConverter();
    private CrossReference overrideAliasSourceDatabase;
    private Collection<CrossReference> sourceDatabases;
    private Pattern FIRST_AUTHOR_REGEX = Pattern.compile("(\\w+(?:\\P{Ps}+)?)(?:\\((\\d{4})\\))?");
    protected static final String IREFINDEX = "irefindex";
    private Collection<ExperimentDescription> experimentList = new ArrayList<ExperimentDescription>();
    private Collection<Interaction> interactions = null;

    public Collection<CrossReference> getSourceDatabase() {
        if (this.sourceDatabases == null) {
            this.sourceDatabases = new ArrayList<CrossReference>();
        }
        return this.sourceDatabases;
    }

    public void addSourceDatabase(CrossReference sourceDatabase) {
        if (sourceDatabase == null) {
            throw new IllegalArgumentException("You must give a non null source database.");
        }
        this.getSourceDatabase().add(sourceDatabase);
    }

    public void setOverrideAliasSourceDatabase(CrossReference overrideAliasSourceDatabase) {
        this.overrideAliasSourceDatabase = overrideAliasSourceDatabase;
    }

    public BinaryInteraction toMitab(Interaction interaction) throws TabConversionException {
        int expCount;
        if (interaction.isNegative()) {
            log.warn((Object)("interaction (id:" + interaction.getId() + ") could not be converted to MITAB25 as it is negative."));
            return null;
        }
        if (interaction.getParticipants().size() != 2) {
            log.warn((Object)("interaction (id:" + interaction.getId() + ") could not be converted to MITAB25 as it does not have exactly 2 participants."));
            return null;
        }
        Iterator<Participant> pi = interaction.getParticipants().iterator();
        Participant pA = pi.next();
        Participant pB = pi.next();
        Interactor interactorA = this.getInteractorConverter().toMitab(pA.getInteractor());
        Interactor interactorB = this.getInteractorConverter().toMitab(pB.getInteractor());
        BinaryInteraction bi = this.newBinaryInteraction(interactorA, interactorB);
        if (interaction.hasXref()) {
            Collection<DbReference> sourceRefs = XrefUtils.searchByType(interaction.getXref(), "source reference", "MI:0685");
            String text = null;
            for (Attribute attr : interaction.getAttributes()) {
                if (!"source reference:label".equals(attr.getName())) continue;
                text = attr.getValue();
                break;
            }
            for (DbReference sourceRef : sourceRefs) {
                String db = "unknown";
                if (sourceRef.getId() != null && sourceRef.getId().startsWith("MI:")) {
                    db = "psi-mi";
                }
                CrossReferenceImpl xref = new CrossReferenceImpl(db, sourceRef.getId(), text);
                bi.getSourceDatabases().add(xref);
            }
        }
        if (bi.getSourceDatabases().isEmpty() && this.sourceDatabases != null) {
            bi.getSourceDatabases().addAll(this.sourceDatabases);
        }
        if (interaction.hasXref()) {
            Collection<DbReference> interactionAcs = XrefUtils.searchByType(interaction.getXref(), "identity", "MI:0356");
            Iterator<DbReference> interactionAcsIter = interactionAcs.iterator();
            block2: while (interactionAcsIter.hasNext()) {
                DbReference identityRef = interactionAcsIter.next();
                for (CrossReference sourceDatabase : bi.getSourceDatabases()) {
                    if (sourceDatabase.getIdentifier().equals(identityRef.getDb()) || sourceDatabase.getIdentifier().equals(identityRef.getDbAc())) continue;
                    interactionAcsIter.remove();
                    continue block2;
                }
            }
            if (interactionAcs.isEmpty() && interaction.hasXref()) {
                interactionAcs.add(interaction.getXref().getPrimaryRef());
            }
            ArrayList<CrossReference> refs = new ArrayList<CrossReference>();
            for (DbReference interactionAc : interactionAcs) {
                refs.add(CrossReferenceFactory.getInstance().build(interactionAc.getDb(), interactionAc.getId()));
            }
            bi.getInteractionAcs().addAll(refs);
        }
        if (interaction.hasInteractionTypes()) {
            ArrayList<InteractionType> types = new ArrayList<InteractionType>(interaction.getInteractionTypes().size());
            for (psidev.psi.mi.xml.model.InteractionType interactionType : interaction.getInteractionTypes()) {
                InteractionType type = this.itConverter.toMitab(interactionType);
                if (type != null) {
                    types.add(type);
                    continue;
                }
                log.warn((Object)("Failed to convert interaction type: " + interactionType));
            }
            if (!types.isEmpty()) {
                bi.setInteractionTypes(types);
            }
        }
        if ((expCount = interaction.getExperiments().size()) > 0) {
            ArrayList<CrossReference> publications = new ArrayList<CrossReference>(expCount);
            bi.setPublications(publications);
            ArrayList<psidev.psi.mi.tab.model.InteractionDetectionMethod> detections = new ArrayList<psidev.psi.mi.tab.model.InteractionDetectionMethod>(expCount);
            bi.setDetectionMethods(detections);
            for (ExperimentDescription experiment : interaction.getExperiments()) {
                CrossReference pub;
                psidev.psi.mi.tab.model.InteractionDetectionMethod detection = this.idmConverter.toMitab(experiment.getInteractionDetectionMethod());
                if (detection != null) {
                    bi.getDetectionMethods().add(detection);
                }
                if (experiment.getBibref() != null && (pub = this.pubConverter.toMitab(experiment.getBibref())) != null) {
                    bi.getPublications().add(pub);
                }
                if (experiment.getAttributes() == null) continue;
                String authorName = "-";
                String pubYear = "";
                for (Attribute attribute : experiment.getAttributes()) {
                    if ("author-list".equals(attribute.getName())) {
                        authorName = attribute.getValue();
                        if (!authorName.contains(",")) continue;
                        authorName = authorName.split(" ")[0].concat(" et al");
                        continue;
                    }
                    if (!"publication year".equals(attribute.getName())) continue;
                    pubYear = "(" + attribute.getValue() + ")";
                }
                String authorNameYear = authorName + " " + pubYear;
                AuthorImpl author = new AuthorImpl(authorNameYear.trim());
                bi.getAuthors().add(author);
            }
        }
        for (Confidence confidence : interaction.getConfidences()) {
            Unit unit = confidence.getUnit();
            String type = null;
            String value = confidence.getValue();
            String text = null;
            if (unit != null) {
                if (unit.getNames() != null) {
                    type = unit.getNames().getShortLabel();
                    text = unit.getNames().getFullName();
                }
            } else {
                type = "unknown";
            }
            ConfidenceImpl tabConfidence = new ConfidenceImpl(type, value, text);
            bi.getConfidenceValues().add(tabConfidence);
        }
        return bi;
    }

    public Collection<ExperimentDescription> getExperimentList() {
        return this.experimentList;
    }

    private DbReference getPrimaryRef(CrossReference interactionAc, CrossReference sourceReference) {
        DbReference primaryRef = null;
        if (interactionAc != null) {
            String id = interactionAc.getIdentifier();
            String db = interactionAc.getDatabase();
            primaryRef = new DbReference(id, db);
            if (sourceReference != null) {
                primaryRef.setDbAc(sourceReference.getIdentifier());
            }
            primaryRef.setRefType("identity");
            primaryRef.setRefTypeAc("MI:0356");
        }
        return primaryRef;
    }

    private Names getInteractionName(Interaction interaction) {
        Names interactionName = null;
        Collection<Participant> participants = interaction.getParticipants();
        for (Participant participant : participants) {
            if (interactionName != null) {
                String shortLabel = interactionName.getShortLabel().concat("-");
                shortLabel = shortLabel.concat(participant.getInteractor().getNames().getShortLabel().split("_")[0]);
                interactionName.setShortLabel(shortLabel);
            }
            if (interactionName != null) continue;
            interactionName = new Names();
            interactionName.setShortLabel(participant.getInteractor().getNames().getShortLabel().split("_")[0]);
        }
        if (interactionName == null) {
            log.warn((Object)"Interaction don't have a name");
        }
        return interactionName;
    }

    private Collection<ExperimentDescription> getExperimentDescriptions(T binaryInteraction, int index) throws XmlConversionException {
        String firstAuthor;
        ArrayList<ExperimentDescription> experimentDescriptions = new ArrayList<ExperimentDescription>();
        ExperimentDescription experimentDescription = null;
        Bibref bibref = null;
        if (binaryInteraction.getPublications().size() <= index) {
            log.warn((Object)("Size of InteractionAcs is " + binaryInteraction.getInteractionAcs().size() + " but we have only " + binaryInteraction.getPublications().size() + " publication(s)! -> We could not know which publication dependents on which InteractionAcs"));
        } else {
            CrossReference binaryPublication = binaryInteraction.getPublications().get(index);
            bibref = this.pubConverter.fromMitab(binaryPublication);
        }
        InteractionDetectionMethod detectionMethod = null;
        if (binaryInteraction.getDetectionMethods().size() <= index) {
            log.warn((Object)("Size of InteractionAcs is " + binaryInteraction.getInteractionAcs().size() + " but we have only " + binaryInteraction.getDetectionMethods().size() + " detectionMethod(s)! -> We could not know which detectionMethode dependents on which InteractionAcs"));
        } else {
            psidev.psi.mi.tab.model.InteractionDetectionMethod binaryDetectionMethod = binaryInteraction.getDetectionMethods().get(index);
            detectionMethod = this.idmConverter.fromMitab(binaryDetectionMethod, InteractionDetectionMethod.class);
        }
        if (bibref != null && detectionMethod != null) {
            experimentDescription = new ExperimentDescription(bibref, detectionMethod);
            experimentDescription.setId(IdentifierGenerator.getInstance().nextId());
        }
        if (index < binaryInteraction.getAuthors().size() && !(firstAuthor = binaryInteraction.getAuthors().get(index).getName()).equals("-")) {
            String shortLabel;
            Names names = new Names();
            Matcher matcher = this.FIRST_AUTHOR_REGEX.matcher(firstAuthor);
            if (matcher.matches()) {
                firstAuthor = matcher.group(1).trim();
                shortLabel = firstAuthor.split(" ")[0];
                if (matcher.groupCount() > 1) {
                    String year = matcher.group(2);
                    shortLabel = shortLabel + "-" + year;
                    Attribute pubYear = new Attribute("publication year", year);
                    experimentDescription.getAttributes().add(pubYear);
                }
            } else {
                shortLabel = firstAuthor.split(" ")[0];
            }
            shortLabel = shortLabel.toLowerCase();
            names.setShortLabel(shortLabel);
            experimentDescription.setNames(names);
            Attribute authorList = new Attribute("author-list", firstAuthor);
            if (!experimentDescription.getAttributes().contains(authorList)) {
                experimentDescription.getAttributes().add(authorList);
            }
        }
        if (!experimentDescriptions.contains(experimentDescription) && experimentDescription != null) {
            experimentDescriptions.add(experimentDescription);
        }
        return experimentDescriptions;
    }

    protected abstract BinaryInteraction newBinaryInteraction(Interactor var1, Interactor var2);

    public abstract InteractorConverter<?> getInteractorConverter();

    private Collection<psidev.psi.mi.xml.model.InteractionType> getInteractionTypes(BinaryInteraction binaryInteraction) {
        ArrayList<psidev.psi.mi.xml.model.InteractionType> types = null;
        if (binaryInteraction.getInteractionTypes() != null) {
            types = new ArrayList<psidev.psi.mi.xml.model.InteractionType>(binaryInteraction.getInteractionTypes().size());
            List<InteractionType> tabInteractionTypes = binaryInteraction.getInteractionTypes();
            for (InteractionType intactType : tabInteractionTypes) {
                psidev.psi.mi.xml.model.InteractionType type = null;
                try {
                    type = this.itConverter.fromMitab(intactType, psidev.psi.mi.xml.model.InteractionType.class);
                }
                catch (XmlConversionException e) {
                    e.printStackTrace();
                }
                if (type != null) {
                    if (types.contains(type)) continue;
                    types.add(type);
                    continue;
                }
                log.warn((Object)("Failed to convert interaction type: " + type));
            }
        }
        return types;
    }

    public Collection<Interaction> fromMitab(BinaryInteraction<?> binaryInteraction, Map<String, Collection<Participant>> interactionMap) throws IllegalAccessException, XmlConversionException {
        this.interactions = new ArrayList<Interaction>();
        HashSet<String> interactionAcs = new HashSet<String>();
        int numberOfInteraction = 1;
        List<CrossReference> acs = binaryInteraction.getInteractionAcs();
        if (acs.isEmpty()) {
            acs.add(new NullCrossReference(binaryInteraction));
        }
        CrossReference interactionAc = acs.get(0);
        String interactionId = interactionAc.getIdentifier();
        if (!interactionAcs.contains(interactionId = interactionId + "_" + ((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier() + "_" + ((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier())) {
            interactionAcs.add(interactionId);
            CrossReference source = binaryInteraction.getSourceDatabases().get(0);
            DbReference primaryReference = this.getPrimaryRef(interactionAc, source);
            Interaction interaction = new Interaction();
            interaction.setId(IdentifierGenerator.getInstance().nextId());
            interaction.setXref(new Xref(primaryReference));
            for (CrossReference sourceXref : binaryInteraction.getSourceDatabases()) {
                String id = sourceXref.getIdentifier();
                String refDbMi = null;
                String refDb = null;
                if (id.startsWith("MI:")) {
                    refDbMi = "MI:0488";
                    refDb = "psi-mi";
                }
                DbReference sourceReference = new DbReference(refDb, refDbMi, id, "source reference", "MI:0685");
                interaction.getXref().getSecondaryRef().add(sourceReference);
                if (!sourceXref.hasText()) continue;
                interaction.getAttributes().add(new Attribute("source reference:label", sourceXref.getText()));
            }
            if (interactionMap.get(interactionId).size() > 1) {
                for (Participant participant : interactionMap.get(interactionId)) {
                    interaction.getParticipants().add(participant);
                }
            }
            if (this.getInteractionName(interaction) != null) {
                Names interactionName = this.getInteractionName(interaction);
                String shortLabel = interactionName.getShortLabel().concat("-".concat(String.valueOf(numberOfInteraction)));
                ++numberOfInteraction;
                interactionName.setShortLabel(shortLabel);
                interaction.setNames(interactionName);
            }
            if (!this.getInteractionTypes(binaryInteraction).isEmpty()) {
                interaction.getInteractionTypes().addAll(this.getInteractionTypes(binaryInteraction));
            }
            Collection<ExperimentDescription> experiments = this.getExperimentDescriptions(binaryInteraction, 0);
            for (ExperimentDescription experimentDescription : experiments) {
                interaction.getExperiments().add(experimentDescription);
            }
            for (psidev.psi.mi.tab.model.Confidence tabConfidence : binaryInteraction.getConfidenceValues()) {
                Unit unit = new Unit();
                unit.setNames(new Names());
                unit.getNames().setShortLabel(tabConfidence.getType());
                if (tabConfidence.getText() != null) {
                    unit.getNames().setFullName(tabConfidence.getText());
                }
                Confidence confidence = new Confidence(unit, tabConfidence.getValue());
                interaction.getConfidences().add(confidence);
            }
            this.populateInteractionFromMitab(interaction, binaryInteraction, 0);
            this.interactions.add(interaction);
        }
        return this.interactions;
    }

    protected abstract void populateInteractionFromMitab(Interaction var1, BinaryInteraction<?> var2, int var3);
}

