/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2xml;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.InteractorIdBuilder;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Names;

public class InteractorUniprotIdBuilder
implements InteractorNameBuilder {
    public static final Log log = LogFactory.getLog(InteractorUniprotIdBuilder.class);

    public Names select(Interactor interactor) {
        Names interactorName = null;
        if (interactor == null) {
            throw new IllegalArgumentException("You must give a non null Interactor.");
        }
        String interactorId = null;
        if (interactor.getAlternativeIdentifiers() != null) {
            for (CrossReference altIdentifier : interactor.getAlternativeIdentifiers()) {
                if (!"gene name".equals(altIdentifier.getText()) || !"uniprotkb".equals(altIdentifier.getDatabase())) continue;
                interactorId = altIdentifier.getIdentifier().toLowerCase();
                break;
            }
        }
        String organismName = null;
        if (interactor.hasOrganism()) {
            for (CrossReference organism : interactor.getOrganism().getIdentifiers()) {
                String name = organism.getText();
                if (name == null) continue;
                organismName = name.toLowerCase();
                break;
            }
        }
        if (interactorId != null && organismName != null) {
            interactorName = new Names();
            interactorName.setShortLabel(interactorId + "_" + organismName);
            if (!interactor.getAliases().isEmpty() && interactorName != null) {
                ArrayList<Alias> aliases = new ArrayList<Alias>();
                for (psidev.psi.mi.tab.model.Alias tabAlias : interactor.getAliases()) {
                    String type = tabAlias.getAliasType();
                    String value = tabAlias.getName();
                    Alias alias = new Alias();
                    alias.setValue(value);
                    alias.setType(type);
                    aliases.add(alias);
                }
                if (!aliases.isEmpty()) {
                    interactorName.getAliases().addAll(aliases);
                }
            }
            return interactorName;
        }
        log.debug((Object)"No uniprotId found -> using InteractorIdBuilder to get a vaild name.");
        InteractorIdBuilder idBuilder = new InteractorIdBuilder();
        return idBuilder.select(interactor);
    }
}

