/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.client.gui.FilesProcessor;
import psidev.psi.mi.tab.client.gui.dnd.DragAndDropComponent;
import psidev.psi.mi.tab.client.gui.dnd.FilesDroppedListener;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.expansion.MatrixExpansion;
import psidev.psi.mi.tab.expansion.SpokeExpansion;
import psidev.psi.mi.tab.processor.ClusterInteractorPairProcessor;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;

public class DragAndDropConverter {
    public static final String ABOUT_CONTENT = "Version 1.0 beta 3\nAuthorImpl: Samuel Kerrien (skerrien@ebi.ac.uk)";
    public static final Log log = LogFactory.getLog(DragAndDropConverter.class);
    private static ExpansionStrategy expansionStrategy = new SpokeExpansion();
    private static PostProcessorStrategy postProcessorStrategy = new ClusterInteractorPairProcessor();
    private static boolean aggregateSelectedFiles = true;

    private static void addMenuBar(JFrame frame) {
        JMenuBar menuBar = new JMenuBar();
        DragAndDropConverter.addFileMenu(frame, menuBar);
        DragAndDropConverter.addExpansionMenu(menuBar);
        DragAndDropConverter.addProcessorMenu(menuBar);
        DragAndDropConverter.addHelpMenu(frame, menuBar);
        frame.setJMenuBar(menuBar);
    }

    public static void addFileMenu(final JFrame frame, JMenuBar menuBar) {
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem openFileItem = new JMenuItem("Open files...");
        openFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText("Convert to MITAB25");
                chooser.setMultiSelectionEnabled(true);
                chooser.showOpenDialog(frame);
                File[] files = chooser.getSelectedFiles();
                if (files != null && files.length > 0) {
                    FilesProcessor processor = new FilesProcessor();
                    processor.process(frame, files, expansionStrategy, postProcessorStrategy, aggregateSelectedFiles);
                }
            }
        });
        menu.add(openFileItem);
        final JCheckBoxMenuItem mergeItem = new JCheckBoxMenuItem("Aggregate all selected files", aggregateSelectedFiles);
        mergeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                aggregateSelectedFiles = mergeItem.isSelected();
                log.debug((Object)("Aggregate is " + aggregateSelectedFiles));
            }
        });
        menu.add(mergeItem);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(exitItem);
    }

    public static void addExpansionMenu(JMenuBar menuBar) {
        ButtonGroup itemGroup = new ButtonGroup();
        JMenu menu = new JMenu("Expansion model");
        menuBar.add(menu);
        JRadioButtonMenuItem noneItem = new JRadioButtonMenuItem("None");
        noneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"No expansion strategy selected.");
                expansionStrategy = null;
            }
        });
        itemGroup.add(noneItem);
        menu.add(noneItem);
        JRadioButtonMenuItem spokeItem = new JRadioButtonMenuItem("Spoke");
        spokeItem.setSelected(true);
        spokeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"Sets expansion statefy to Spoke.");
                expansionStrategy = new SpokeExpansion();
            }
        });
        itemGroup.add(spokeItem);
        menu.add(spokeItem);
        JRadioButtonMenuItem matrixItem = new JRadioButtonMenuItem("Matrix");
        matrixItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"Sets expansion statefy to Matrix.");
                expansionStrategy = new MatrixExpansion();
            }
        });
        itemGroup.add(matrixItem);
        menu.add(matrixItem);
    }

    public static void addProcessorMenu(JMenuBar menuBar) {
        JMenu menu = new JMenu("Processing");
        menuBar.add(menu);
        ButtonGroup itemGroup = new ButtonGroup();
        JRadioButtonMenuItem noneItem = new JRadioButtonMenuItem("None");
        noneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"Disables post processing.");
                postProcessorStrategy = null;
            }
        });
        itemGroup.add(noneItem);
        menu.add(noneItem);
        JRadioButtonMenuItem clusteringInteractorItem = new JRadioButtonMenuItem("Clustering interactor pairs");
        clusteringInteractorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"Enables post processing: ClusterPerInteractorProcessor");
                postProcessorStrategy = new ClusterInteractorPairProcessor();
            }
        });
        itemGroup.add(clusteringInteractorItem);
        clusteringInteractorItem.setSelected(true);
        menu.add(clusteringInteractorItem);
    }

    private static void addHelpMenu(final JFrame frame, JMenuBar menuBar) {
        JMenu menu = new JMenu("Help");
        menuBar.add(menu);
        JMenuItem item = new JMenuItem("About");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(frame, DragAndDropConverter.ABOUT_CONTENT, "About PSIMITAB Converter", 1);
            }
        });
        menu.add(item);
    }

    public static void main(String[] args) throws FileNotFoundException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error((Object)"Failed to change Look and Feel.", (Throwable)e);
        }
        final JFrame frame = new JFrame("MITAB25 Converter");
        frame.setPreferredSize(new Dimension(400, 200));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        frame.add(panel);
        DragAndDropConverter.addMenuBar(frame);
        JLabel label = new JLabel("Drag and drop your XML file(s) here");
        ((Component)label).setPreferredSize(new Dimension(400, 200));
        ((Component)label).setForeground(Color.red);
        panel.add(label);
        PrintStream out = null;
        new DragAndDropComponent(out, panel, new FilesDroppedListener(){

            public void filesDropped(File[] files) {
                FilesProcessor processor = new FilesProcessor();
                processor.process(frame, files, expansionStrategy, postProcessorStrategy, aggregateSelectedFiles);
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 50, 50);
        frame.pack();
        frame.setVisible(true);
    }
}

