/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.builder.DocumentDefinition;
import psidev.psi.mi.tab.model.builder.MitabDocumentDefinition;
import psidev.psi.mi.xml.converter.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabWriter {
    public static final Log log = LogFactory.getLog(PsimiTabWriter.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    boolean headerAlreadyWritten = false;
    private boolean headerEnabled = true;
    private DocumentDefinition documentDefinition;

    public PsimiTabWriter() {
        this(true);
    }

    public PsimiTabWriter(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
        this.documentDefinition = new MitabDocumentDefinition();
    }

    public PsimiTabWriter(DocumentDefinition documentDefinition, boolean headerEnabled) {
        this.documentDefinition = documentDefinition;
        this.headerEnabled = headerEnabled;
    }

    public boolean hasHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
    }

    public void writeOrAppend(BinaryInteraction binaryInteraction, File file, boolean createFile) throws IOException {
        FileWriter writer;
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            if (createFile && log.isWarnEnabled()) {
                log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        }
        if (createFile && this.hasHeaderEnabled()) {
            writer = new FileWriter(file, false);
            writer.write(this.buildHeaderLine() + NEW_LINE);
        } else {
            writer = new FileWriter(file, true);
        }
        String line = this.documentDefinition.interactionToString(binaryInteraction);
        writer.write(line + NEW_LINE);
        ((Writer)writer).close();
    }

    public void writeOrAppend(Collection<BinaryInteraction> interactions, File file, boolean createFile) throws IOException, ConverterException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            if (createFile && log.isWarnEnabled()) {
                log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        }
        if (createFile) {
            this.write(interactions, file);
        } else {
            FileWriter writer = new FileWriter(file, true);
            for (BinaryInteraction binaryInteraction : interactions) {
                String line = this.documentDefinition.interactionToString(binaryInteraction);
                ((Writer)writer).append(line + NEW_LINE);
            }
            ((Writer)writer).close();
        }
    }

    public void write(Collection<BinaryInteraction> interactions, File file) throws IOException, ConverterException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        this.write(interactions, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public void write(Collection<BinaryInteraction> interactions, OutputStream os) throws IOException, ConverterException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        this.write(interactions, (Writer)writer);
        writer.flush();
    }

    public void write(Collection<BinaryInteraction> interactions, Writer writer) throws IOException, ConverterException {
        if (!this.headerAlreadyWritten && this.hasHeaderEnabled()) {
            writer.write(this.buildHeaderLine() + NEW_LINE);
            this.headerAlreadyWritten = true;
        }
        for (BinaryInteraction binaryInteraction : interactions) {
            String line = this.documentDefinition.interactionToString(binaryInteraction);
            writer.write(line + NEW_LINE);
        }
    }

    public void write(Collection<BinaryInteraction> interactions, PrintStream ps) throws IOException, ConverterException {
        OutputStreamWriter writer = new OutputStreamWriter(ps);
        this.write(interactions, (Writer)writer);
        writer.close();
    }

    public void write(BinaryInteraction interaction, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        this.write(interaction, (Writer)writer);
        writer.close();
    }

    public void write(BinaryInteraction interaction, Writer writer) throws IOException {
        if (!this.headerAlreadyWritten && this.hasHeaderEnabled()) {
            writer.write(this.buildHeaderLine() + NEW_LINE);
            this.headerAlreadyWritten = true;
        }
        String line = this.documentDefinition.interactionToString(interaction);
        writer.write(line + NEW_LINE);
    }

    private String buildHeaderLine() {
        StringBuilder sb = new StringBuilder(256);
        if (this.documentDefinition == null) {
            throw new IllegalStateException("You cannot request a header without giving a valid documentDefinition.");
        }
        int columnCount = this.documentDefinition.getColumnsCount();
        sb.append("#");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                sb.append("\t");
            }
            String columnName = this.documentDefinition.getColumnDefinition(i).getColumnName();
            sb.append(columnName);
        }
        return sb.toString();
    }
}

