/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.builder.DocumentDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabIterator
implements Iterator<BinaryInteraction> {
    private DocumentDefinition documentDefinition;
    private BufferedReader interactionStreamReader;
    private boolean hasHeader;
    private String nextLine;
    private int interactionsProcessedCount = 0;
    private int lineIndex = 0;
    private boolean lineConsummed = true;

    public PsimiTabIterator(DocumentDefinition documentDefinition, Reader psiMiTabInteractionsReader, boolean hasHeaderLine) {
        if (documentDefinition == null) {
            throw new NullPointerException("You must give a non null document definition.");
        }
        if (psiMiTabInteractionsReader == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        this.documentDefinition = documentDefinition;
        this.interactionStreamReader = new BufferedReader(psiMiTabInteractionsReader);
        this.hasHeader = hasHeaderLine;
        try {
            if (this.hasHeader) {
                this.readNextLine();
                ++this.lineIndex;
            }
        }
        catch (IOException e) {
            this.closeStreamReader();
            throw new RuntimeException("Error while reading the header line.", e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.lineConsummed) {
                this.nextLine = this.readNextLine();
                ++this.lineIndex;
                if (this.nextLine != null && this.nextLine.startsWith("#")) {
                    return this.hasNext();
                }
                this.lineConsummed = false;
            }
        }
        catch (IOException e) {
            this.closeStreamReader();
            return false;
        }
        return this.nextLine != null;
    }

    @Override
    public BinaryInteraction next() {
        if (this.nextLine == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        BinaryInteraction interaction = null;
        try {
            interaction = (BinaryInteraction)this.documentDefinition.interactionFromString(this.nextLine);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception upon parsing at line " + this.lineIndex, e);
        }
        ++this.interactionsProcessedCount;
        this.lineConsummed = true;
        this.nextLine = null;
        return interaction;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getInteractionsProcessedCount() {
        return this.interactionsProcessedCount;
    }

    private String readNextLine() throws IOException {
        String line = null;
        if (this.interactionStreamReader != null && (line = this.interactionStreamReader.readLine()) == null) {
            this.closeStreamReader();
            this.interactionStreamReader = null;
        }
        return line;
    }

    private void closeStreamReader() {
        if (this.interactionStreamReader != null) {
            try {
                this.interactionStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

