/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.datasource.DataSource;
import org.cytoscape.io.datasource.DataSourceManager;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLHandler
extends AbstractGUITunableHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JComboBox<String> networkFileComboBox;
    private final Map<String, String> dataSourceMap = new HashMap<String, String>();

    public URLHandler(Field f, Object o, Tunable t, DataSourceManager manager) {
        super(f, o, t);
        this.init(manager);
    }

    public URLHandler(Method getter, Method setter, Object instance, Tunable tunable, DataSourceManager manager) {
        super(getter, setter, instance, tunable);
        this.init(manager);
    }

    private void init(DataSourceManager dsManager) {
        this.initGUI();
        Collection dataSources = dsManager.getDataSources(DataCategory.valueOf((String)((String)this.getParams().get("fileCategory")).toUpperCase()));
        TreeSet<CallSite> labelSet = new TreeSet<CallSite>();
        if (dataSources != null) {
            for (DataSource dataSource : dataSources) {
                String link = null;
                link = dataSource.getLocation().toString();
                String sourceName = dataSource.getName();
                String provider = dataSource.getProvider();
                String sourceLabel = provider + ":" + sourceName;
                this.dataSourceMap.put(sourceLabel, link);
                labelSet.add((CallSite)((Object)sourceLabel));
            }
        }
        for (String string : labelSet) {
            this.networkFileComboBox.addItem(string);
        }
    }

    public void handle() {
        Object selected = this.networkFileComboBox.getSelectedItem();
        if (selected == null) {
            return;
        }
        String selectedString = selected.toString();
        String urlString = !selectedString.startsWith("http:") && !selectedString.startsWith("https:") ? this.dataSourceMap.get(selectedString) : selectedString;
        if (urlString != null) {
            try {
                this.setValue(new URL(urlString));
            }
            catch (Exception e) {
                logger.error("Could not create URL: " + urlString, (Throwable)e);
            }
        }
    }

    private void initGUI() {
        ToolTipManager tipManager = ToolTipManager.sharedInstance();
        tipManager.setInitialDelay(1);
        tipManager.setDismissDelay(7500);
        this.networkFileComboBox = new JComboBox();
        this.networkFileComboBox.setEditable(true);
        this.networkFileComboBox.setName("networkFileComboBox");
        this.networkFileComboBox.setToolTipText("<html><body>You can specify URL by the following:<ul><li>Type URL</li><li>Select from pull down menu</li><li>Drag & Drop URL from Web Browser</li></ul></body><html>");
        this.networkFileComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setToolTipText(value != null ? value.toString() : null);
                return this;
            }
        });
        this.networkFileComboBox.setPreferredSize(new Dimension(660, this.networkFileComboBox.getPreferredSize().height));
        this.networkFileComboBox.setMaximumSize(this.networkFileComboBox.getPreferredSize());
        JLabel label = new JLabel("Import data from URL:");
        GUIDefaults.updateFieldPanel(this.panel, label, this.networkFileComboBox, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), label, this.networkFileComboBox);
    }
}

