/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JPanel;
import org.cytoscape.work.internal.tunables.JPanelTunableMutator;
import org.cytoscape.work.internal.tunables.utils.SimplePanel;
import org.cytoscape.work.internal.tunables.utils.TunableDialog;
import org.cytoscape.work.swing.GUITunableHandler;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;

public class JDialogTunableMutator
extends JPanelTunableMutator
implements TunableUIHelper {
    private Window parent;
    private Dialog.ModalityType modality = Dialog.DEFAULT_MODALITY_TYPE;
    private TunableDialog dialogWindow;

    public void setConfigurationContext(Object win, boolean resetContext) {
        if (win == null) {
            if (resetContext) {
                this.handlerMap.clear();
                this.titleProviderMap.clear();
            }
            return;
        }
        if (!(win instanceof Window)) {
            throw new IllegalArgumentException("Dialog configuration context must be a Window, but it's a: " + win.getClass());
        }
        this.parent = (Window)win;
    }

    @Override
    public JPanel buildConfiguration(Object objectWithTunables) {
        return super.buildConfiguration(objectWithTunables, this.parent);
    }

    @Override
    public boolean validateAndWriteBack(Object objectWithTunables) {
        JPanel panel = this.buildConfiguration(objectWithTunables, this.parent);
        return this.validateAndWriteBack(panel, objectWithTunables);
    }

    public boolean validateAndWriteBack(JPanel panel, Object objectWithTunables) {
        if (panel == null) {
            return true;
        }
        if (panel == this.HANDLER_CANCEL_PANEL) {
            return false;
        }
        if (panel instanceof SimplePanel && !((SimplePanel)panel).hasEnabledControls(panel)) {
            return super.validateAndWriteBack(objectWithTunables);
        }
        return this.displayGUI(panel, objectWithTunables);
    }

    private boolean displayGUI(JPanel optionPanel, Object objectWithTunables) {
        String userInput;
        boolean valid = false;
        do {
            TunableDialog tunableDialog;
            this.dialogWindow = tunableDialog = new TunableDialog(this.parent, optionPanel);
            tunableDialog.setLocationRelativeTo(this.parent);
            if (objectWithTunables instanceof RequestsUIHelper) {
                ((RequestsUIHelper)objectWithTunables).setUIHelper((TunableUIHelper)this);
            }
            tunableDialog.setTitle(this.getTitle(objectWithTunables));
            tunableDialog.setModalityType(this.modality);
            tunableDialog.setVisible(true);
            userInput = tunableDialog.getUserInput();
            optionPanel = tunableDialog.getOptionPanel();
            if (!userInput.equalsIgnoreCase("OK")) continue;
            valid = super.validateAndWriteBack(objectWithTunables);
        } while (userInput.equalsIgnoreCase("OK") && !valid);
        return userInput.equalsIgnoreCase("OK") ? valid : false;
    }

    @Override
    public Window getParent() {
        return this.dialogWindow;
    }

    @Override
    public void setModality(Dialog.ModalityType modality) {
        this.modality = modality;
    }

    @Override
    public void update(Object objectWithTunables) {
        if (!this.handlerMap.containsKey(objectWithTunables)) {
            return;
        }
        if (this.handlers != null && this.handlers.size() > 0) {
            for (GUITunableHandler handler : this.handlers) {
                handler.update();
            }
        }
    }

    @Override
    public void refresh(Object objectWithTunables) {
        if (!this.handlerMap.containsKey(objectWithTunables)) {
            return;
        }
        this.handlerMap.remove(objectWithTunables);
        this.titleProviderMap.remove(objectWithTunables);
        JPanel panel = this.buildConfiguration(objectWithTunables, this.parent);
        this.dialogWindow.updateOptionPanel(panel);
        this.update(objectWithTunables);
    }
}

