/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.DirectlyPresentableTunableHandler;

public class BooleanHandler
extends AbstractGUITunableHandler
implements ActionListener,
DirectlyPresentableTunableHandler {
    private JCheckBox checkBox;
    private JOptionPane optionPane;
    private boolean useOptionPane;
    private int selectedOption;
    private boolean isUpdating = false;

    public BooleanHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public BooleanHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(this.getBoolean());
        this.checkBox.addActionListener(this);
        JLabel label = new JLabel(this.getDescription());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (BooleanHandler.this.checkBox.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    BooleanHandler.this.checkBox.doClick();
                    BooleanHandler.this.checkBox.requestFocusInWindow();
                }
            }
        });
        GUIDefaults.updateFieldPanel(this.panel, label, (Component)this.checkBox, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), label, this.checkBox);
    }

    private boolean getBoolean() {
        try {
            return (Boolean)this.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void update() {
        this.isUpdating = true;
        try {
            boolean b = (Boolean)this.getValue();
            this.checkBox.setSelected(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isUpdating = false;
    }

    public boolean isForcedToSetDirectly() {
        return this.getParams().getProperty("ForceSetDirectly", "false").equalsIgnoreCase("true");
    }

    public boolean setTunableDirectly(Window possibleParent) {
        this.selectedOption = this.setOptionPaneGUI(possibleParent);
        this.useOptionPane = true;
        this.handle();
        this.useOptionPane = false;
        return this.selectedOption != 2;
    }

    private int setOptionPaneGUI(Window possibleParent) {
        return JOptionPane.showOptionDialog(possibleParent, this.getDescription(), this.getParams().getProperty("ForceSetTitle", " "), 2, -1, null, null, null);
    }

    public void handle() {
        try {
            Boolean setting = this.useOptionPane ? Boolean.valueOf(this.selectedOption == 0) : Boolean.valueOf(this.checkBox.isSelected());
            this.setValue(setting);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getState() {
        return String.valueOf(this.checkBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isUpdating) {
            this.handle();
        }
    }
}

