/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.task;

import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.internal.task.TaskHistory;
import org.cytoscape.work.internal.view.TaskMediator;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class CyUserLogAppender
implements PaxAppender {
    private final TaskMediator taskMediator;
    private final TaskHistory history;

    public CyUserLogAppender(TaskMediator taskMediator, TaskHistory history) {
        this.taskMediator = taskMediator;
        this.history = history;
    }

    public void doAppend(PaxLoggingEvent event) {
        TaskMonitor.Level level = CyUserLogAppender.getCorrespondingLevel(event.getLevel().toInt());
        String message = event.getMessage();
        this.history.addUnnestedMessage(level, message);
        this.taskMediator.setTitle(level, message);
        if (event.getThrowableStrRep() != null) {
            for (String line : event.getThrowableStrRep()) {
                System.err.println(line);
            }
        }
    }

    private static TaskMonitor.Level getCorrespondingLevel(int level) {
        switch (level) {
            case 4: {
                return TaskMonitor.Level.ERROR;
            }
            case 3: {
                return TaskMonitor.Level.WARN;
            }
        }
        return TaskMonitor.Level.INFO;
    }
}

