/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import org.cytoscape.editor.internal.RenameNodeEdit;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RenameNodeTask
extends AbstractTask {
    CyNetwork net;
    CyNode node;
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="New name for node:")
    public String newName;

    public RenameNodeTask(CyNetworkView netView, View<? extends CyIdentifiable> objView, CyServiceRegistrar serviceRegistrar) {
        this.net = (CyNetwork)netView.getModel();
        this.serviceRegistrar = serviceRegistrar;
        if (objView.getModel() instanceof CyNode) {
            this.node = (CyNode)objView.getModel();
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.node == null) {
            return;
        }
        CyRow nodeRow = this.net.getRow((CyIdentifiable)this.node);
        String oldName = (String)nodeRow.get("name", String.class);
        nodeRow.set("name", (Object)this.newName);
        nodeRow.set("shared name", (Object)this.newName);
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        undoSupport.postEdit((AbstractCyEdit)new RenameNodeEdit(this.net, this.node, oldName, this.newName));
    }
}

