/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.work.undo.AbstractCyEdit;

public class RenameNodeEdit
extends AbstractCyEdit {
    private final CyRow nodeRow;
    private final String oldName;
    private final String newName;

    public RenameNodeEdit(CyNetwork net, CyNode node, String oldName, String newName) {
        super("Rename Node");
        this.nodeRow = net.getRow((CyIdentifiable)node);
        this.oldName = oldName;
        this.newName = newName;
    }

    public void redo() {
        this.setName(this.newName);
    }

    public void undo() {
        this.setName(this.oldName);
    }

    private void setName(String name) {
        this.nodeRow.set("name", (Object)name);
        this.nodeRow.set("shared name", (Object)name);
    }
}

