/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.editor.internal.ClipboardImpl;
import org.cytoscape.editor.internal.ClipboardManagerImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.undo.AbstractCyEdit;

public class PasteEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private final Point2D xformPt;
    private final ClipboardImpl clipboard;
    private final Collection<CyIdentifiable> pastedObjects;
    private final CyServiceRegistrar serviceRegistrar;

    public PasteEdit(CyNetworkView view, Point2D xformPt, ClipboardManagerImpl clipMgr, Collection<CyIdentifiable> pastedObjects, CyServiceRegistrar serviceRegistrar) {
        super("Paste");
        this.view = view;
        this.xformPt = xformPt;
        this.clipboard = clipMgr.getCurrentClipboard();
        this.pastedObjects = pastedObjects;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void undo() {
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        for (CyIdentifiable object : this.pastedObjects) {
            if (object instanceof CyEdge) {
                edgeList.add((CyEdge)object);
                continue;
            }
            if (!(object instanceof CyNode)) continue;
            nodeList.add((CyNode)object);
        }
        ((CyNetwork)this.view.getModel()).removeEdges(edgeList);
        ((CyNetwork)this.view.getModel()).removeNodes(nodeList);
        this.view.updateView();
    }

    public void redo() {
        Collection<CyIdentifiable> pastedObjects = null;
        pastedObjects = this.xformPt == null ? this.clipboard.paste(this.view, 0.0, 0.0) : this.clipboard.paste(this.view, this.xformPt.getX(), this.xformPt.getY());
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle vs = vmMgr.getVisualStyle(this.view);
        for (CyIdentifiable element : pastedObjects) {
            View elementView = null;
            if (element instanceof CyNode) {
                elementView = this.view.getNodeView((CyNode)element);
            } else {
                if (!(element instanceof CyEdge)) continue;
                elementView = this.view.getEdgeView((CyEdge)element);
            }
            vs.apply(((CyNetwork)this.view.getModel()).getRow(element), elementView);
        }
        this.view.updateView();
    }
}

