/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import org.cytoscape.editor.internal.GoToNestedNetworkTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class GoToNestedNetworkTaskFactory
extends AbstractNodeViewTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public GoToNestedNetworkTaskFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView networkView) {
        return new TaskIterator(new Task[]{new GoToNestedNetworkTask(nodeView, networkView, this.serviceRegistrar)});
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView networkView) {
        if (!super.isReady(nodeView, networkView)) {
            return false;
        }
        CyNode node = (CyNode)nodeView.getModel();
        CyNetwork np = node.getNetworkPointer();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        return np != null && netMgr.networkExists(np.getSUID().longValue());
    }
}

