/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTask;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class GoToNestedNetworkTask
extends AbstractNodeViewTask {
    private final CyServiceRegistrar serviceRegistrar;

    public GoToNestedNetworkTask(View<CyNode> nv, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(nv, view);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        CyNode node = (CyNode)this.nodeView.getModel();
        CyNetwork netPointer = node.getNetworkPointer();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (netPointer != null && netMgr.networkExists(netPointer.getSUID().longValue())) {
            CyNetworkView pointerView = null;
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            Collection views = netViewMgr.getNetworkViews(netPointer);
            Iterator iterator = views.iterator();
            if (iterator.hasNext()) {
                CyNetworkView nv;
                pointerView = nv = (CyNetworkView)iterator.next();
            }
            if (pointerView == null) {
                HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
                networks.add(netPointer);
                CreateNetworkViewTaskFactory createViewFactory = (CreateNetworkViewTaskFactory)this.serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
                TaskIterator iter = createViewFactory.createTaskIterator(networks);
                this.insertTasksAfterCurrentTask(iter);
            } else {
                CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
                appMgr.setCurrentNetworkView(pointerView);
            }
        }
    }
}

