/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import org.cytoscape.editor.internal.AddNodeEdit;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class AddNodeTask
extends AbstractNetworkViewTask
implements ObservableTask {
    private final Point2D xformPt;
    private final String nodeName;
    private final CyServiceRegistrar registrar;
    private boolean postUndo = true;
    private CyNode node;

    public AddNodeTask(CyNetworkView view, Point2D xformPt, String nodeName, CyServiceRegistrar registrar) {
        super(view);
        this.xformPt = xformPt;
        this.nodeName = nodeName;
        this.registrar = registrar;
    }

    public void setPostUndo(boolean postUndo) {
        this.postUndo = postUndo;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Add Node");
        tm.setStatusMessage("Adding node '" + this.nodeName + "'...");
        CyNetwork net = (CyNetwork)this.view.getModel();
        this.node = net.addNode();
        CyRow nodeRow = net.getRow((CyIdentifiable)this.node);
        nodeRow.set("name", (Object)this.nodeName);
        CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
        eventHelper.flushPayloadEvents();
        View nv = this.view.getNodeView(this.node);
        nv.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)this.xformPt.getX());
        nv.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)this.xformPt.getY());
        VisualMappingManager vmMgr = (VisualMappingManager)this.registrar.getService(VisualMappingManager.class);
        VisualStyle vs = vmMgr.getVisualStyle(this.view);
        vs.apply(net.getRow((CyIdentifiable)this.node), nv);
        this.view.updateView();
        if (this.postUndo) {
            AddNodeEdit addNodeEdit = new AddNodeEdit(this.view, this.node, this.xformPt, this.nodeName, this.registrar);
            addNodeEdit.post();
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        return CyNode.class.equals(type) ? (R)type.cast(this.node) : null;
    }
}

