/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.util.ArrayList;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class AddNestedNetworkTask
extends AbstractNodeViewTask {
    private static final String HAS_NESTED_NETWORK_ATTRIBUTE = "has_nested_network";
    @Tunable(description="Network:")
    public ListSingleSelection<CyNetwork> nestedNetwork;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Choose Network for Node";
    }

    public AddNestedNetworkTask(View<CyNode> nv, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(nv, view);
        this.serviceRegistrar = serviceRegistrar;
        CyNetworkManager netMgr = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
        ArrayList networks = new ArrayList(netMgr.getNetworkSet());
        this.nestedNetwork = new ListSingleSelection(networks);
        CyNetwork netPointer = ((CyNode)this.nodeView.getModel()).getNetworkPointer();
        if (netPointer != null && networks.contains(netPointer)) {
            this.nestedNetwork.setSelectedValue((Object)netPointer);
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        CyNode node = (CyNode)this.nodeView.getModel();
        this.setNestedNetwork(node, (CyNetwork)this.nestedNetwork.getSelectedValue());
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle style = vmMgr.getVisualStyle(this.netView);
        style.apply(((CyNetwork)this.netView.getModel()).getRow((CyIdentifiable)node), this.nodeView);
        this.netView.updateView();
    }

    private void setNestedNetwork(CyNode node, CyNetwork targetNetwork) {
        boolean attributeExists;
        node.setNetworkPointer(targetNetwork);
        CyNetwork sourceNetwork = (CyNetwork)this.netView.getModel();
        CyTable nodeTable = sourceNetwork.getDefaultNodeTable();
        boolean bl = attributeExists = nodeTable.getColumn(HAS_NESTED_NETWORK_ATTRIBUTE) != null;
        if (targetNetwork == null && attributeExists) {
            nodeTable.getRow((Object)node.getSUID()).set(HAS_NESTED_NETWORK_ATTRIBUTE, (Object)false);
        } else if (targetNetwork != null) {
            if (!attributeExists) {
                nodeTable.createColumn(HAS_NESTED_NETWORK_ATTRIBUTE, Boolean.class, false);
            }
            CyRow row = nodeTable.getRow((Object)node.getSUID());
            row.set(HAS_NESTED_NETWORK_ATTRIBUTE, (Object)true);
        }
    }
}

