/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.linkout.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkoutTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final String link;
    private final CyIdentifiable[] tableEntries;
    private final OpenBrowser browser;
    private final CyNetwork network;
    private static final String REGEX = "%.+?%";
    private static final Pattern regexPattern = Pattern.compile("%.+?%");

    public LinkoutTask(String link, OpenBrowser browser, CyNetwork network, CyIdentifiable ... tableEntries) {
        this.link = link;
        this.tableEntries = tableEntries;
        this.browser = browser;
        this.network = network;
    }

    public void run(TaskMonitor tm) {
        String url = this.computeUrl();
        logger.debug("LinkOut opening url: " + url);
        if (!LinkoutTask.isValidUrl(url)) {
            throw new RuntimeException("URL has an incorrect format: " + url);
        }
        if (!this.browser.openURL(url)) {
            throw new RuntimeException("Problem opening linkout URL: " + url);
        }
    }

    public String computeUrl() {
        String url = this.link;
        if (this.tableEntries.length == 1) {
            url = this.substituteAttributes(url, this.tableEntries[0], "ID");
        } else if (this.tableEntries.length == 2) {
            url = this.substituteAttributes(url, this.tableEntries[0], "ID1");
            url = this.substituteAttributes(url, this.tableEntries[1], "ID2");
        } else if (this.tableEntries.length == 3) {
            url = this.substituteAttributes(url, this.tableEntries[0], "ID1");
            url = this.substituteAttributes(url, this.tableEntries[1], "ID2");
            url = this.substituteAttributes(url, this.tableEntries[2], "ID");
        }
        return url;
    }

    private static boolean isValidUrl(String url) {
        try {
            new URI(url);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean isValidUrl() {
        return LinkoutTask.isValidUrl(this.computeUrl());
    }

    private String substituteAttributes(String url, CyIdentifiable tableEntry, String id) {
        Matcher mat = regexPattern.matcher(url);
        while (mat.find()) {
            Object raw;
            String attrName;
            String replaceName = attrName = url.substring(mat.start() + 1, mat.end() - 1);
            if (attrName.equals(id)) {
                attrName = "name";
            }
            if ((raw = this.network.getRow(tableEntry).getRaw(attrName)) == null) continue;
            String attrValue = raw.toString();
            String attrValueEscaped = null;
            try {
                attrValueEscaped = URLEncoder.encode(attrValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            url = url.replace("%" + replaceName + "%", attrValueEscaped);
            mat = regexPattern.matcher(url);
        }
        return url;
    }
}

