/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.task;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.cytoscape.rest.internal.resource.CyRESTSwagger;
import org.cytoscape.rest.internal.resource.apps.AppConstants;
import org.cytoscape.rest.internal.task.SwaggerResourceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);
    public static final String PORT_NUMBER_PROP = "rest.port";
    public static final Integer DEF_PORT_NUMBER = 1234;
    public static final String HOST = "localhost";
    private CyRESTSwagger swagger;
    private SwaggerResourceTracker swaggerResourceTracker;
    private long loadTime;
    private BundleContext bundleContext;
    private final List<ServiceRegistration> serviceRegistrations;
    public final Class<?>[] coreResourceClasses;
    private final Module coreServicesModule;
    private final Map<Class<?>, Module> shimResources;

    public ResourceManager(BundleContext bundleContext, Class<?>[] coreResourceClasses, Module coreServicesModule, Map<Class<?>, Module> shimResources) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.coreResourceClasses = coreResourceClasses;
        this.coreServicesModule = coreServicesModule;
        this.shimResources = shimResources;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
    }

    public void registerResourceServices() throws Exception {
        this.loadTime = System.currentTimeMillis();
        Injector injector = Guice.createInjector((Module[])new Module[]{this.coreServicesModule});
        for (Class<?> clazz : this.coreResourceClasses) {
            Object instance = injector.getInstance(clazz);
            this.serviceRegistrations.add(this.bundleContext.registerService(clazz.getName(), instance, new Hashtable()));
        }
        for (Map.Entry entry : this.shimResources.entrySet()) {
            if (AppConstants.hasValidAppRoot((Class)entry.getKey())) {
                Object instance = injector.getInstance((Class)entry.getKey());
                if (entry.getValue() != null) {
                    Injector appInjector = Guice.createInjector((Module[])new Module[]{(Module)entry.getValue()});
                    appInjector.injectMembers(instance);
                }
                this.serviceRegistrations.add(this.bundleContext.registerService(((Class)entry.getKey()).getName(), instance, new Hashtable()));
                continue;
            }
            logger.error("App resource " + ((Class)entry.getKey()).getName() + " has an invalid @Path annotation, and could not be loaded.");
        }
        this.swagger = (CyRESTSwagger)injector.getInstance(CyRESTSwagger.class);
        this.swaggerResourceTracker = new SwaggerResourceTracker(this.bundleContext, this.bundleContext.createFilter("(&(objectClass=*)(!(com.eclipsesource.jaxrs.publish=false)))"), this.swagger);
        this.swaggerResourceTracker.open();
        this.serviceRegistrations.add(this.bundleContext.registerService(CyRESTSwagger.class.getName(), (Object)this.swagger, new Hashtable()));
        this.loadTime = System.currentTimeMillis() - this.loadTime;
        logger.info("========== Cytoscape RESTful API registered core resources in (" + this.loadTime + ") milliseconds.");
    }

    public void unregisterResourceServices() {
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this.swaggerResourceTracker.close();
        this.swaggerResourceTracker = null;
    }
}

