/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.rest.internal.serializer.ContinuousMappingSerializer;
import org.cytoscape.rest.internal.serializer.DiscreteMappingSerializer;
import org.cytoscape.rest.internal.serializer.PassthroughMappingSerializer;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.values.VisualPropertyValue;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class VisualStyleSerializer {
    private final DiscreteMappingSerializer discSerializer = new DiscreteMappingSerializer();
    private final PassthroughMappingSerializer passhthroughSerializer = new PassthroughMappingSerializer();
    private final ContinuousMappingSerializer continuousSerializer = new ContinuousMappingSerializer();

    public final String serializeDefaults(Collection<VisualProperty<?>> vps, VisualStyle style) throws IOException {
        JsonFactory factory = new JsonFactory();
        TreeMap names = new TreeMap();
        for (VisualProperty<?> vp : vps) {
            names.put(vp.getIdString(), vp);
        }
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        this.addDefaults(generator, names, style);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeVisualProperty(VisualProperty vp) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        this.serializeVisualProperty(generator, (VisualProperty<Object>)vp);
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    private final void serializeVisualProperty(JsonGenerator generator, VisualProperty<Object> vp) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("visualProperty", vp.getIdString());
        generator.writeStringField("name", vp.getDisplayName());
        generator.writeStringField("targetDataType", vp.getTargetDataType().getSimpleName());
        generator.writeStringField("default", vp.toSerializableString(vp.getDefault()));
        generator.writeEndObject();
    }

    public final String serializeDefault(VisualProperty<Object> vp, VisualStyle style) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeStringField("visualProperty", vp.getIdString());
        generator.writeFieldName("value");
        Object value = style.getDefaultValue(vp);
        if (value == null) {
            value = vp.getDefault();
        }
        this.writeValue(vp, value, generator);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeDiscreteRange(VisualProperty<Object> vp, DiscreteRange<Object> range) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeStringField("visualProperty", vp.getIdString());
        generator.writeArrayFieldStart("values");
        for (Object obj : range.values()) {
            VisualPropertyValue vpv = (VisualPropertyValue)obj;
            generator.writeString(vpv.getSerializableString());
        }
        generator.writeEndArray();
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeStyle(Collection<VisualProperty<?>> vps, VisualStyle style) throws IOException {
        TreeMap names = new TreeMap();
        for (VisualProperty<?> vp : vps) {
            names.put(vp.getIdString(), vp);
        }
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeStringField("title", style.getTitle());
        this.addDefaults(generator, names, style);
        this.addMappings(generator, style);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    private void addDefaults(JsonGenerator generator, SortedMap<String, VisualProperty<?>> names, VisualStyle style) throws IOException {
        generator.writeArrayFieldStart("defaults");
        for (String name : names.keySet()) {
            VisualProperty vp = (VisualProperty)names.get(name);
            Object newValue = style.getDefaultValue(vp);
            if (newValue == null) {
                newValue = vp.getDefault();
            }
            generator.writeStartObject();
            generator.writeStringField("visualProperty", vp.getIdString());
            generator.writeFieldName("value");
            this.writeValue((VisualProperty<Object>)vp, newValue, generator);
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    private void addMappings(JsonGenerator generator, VisualStyle style) throws JsonProcessingException, IOException {
        generator.writeArrayFieldStart("mappings");
        for (VisualMappingFunction mapping : style.getAllVisualMappingFunctions()) {
            if (mapping instanceof DiscreteMapping) {
                this.discSerializer.serialize((DiscreteMapping)mapping, generator, (SerializerProvider)null);
                continue;
            }
            if (mapping instanceof ContinuousMapping) {
                this.continuousSerializer.serialize((ContinuousMapping)mapping, generator, (SerializerProvider)null);
                continue;
            }
            if (!(mapping instanceof PassthroughMapping)) continue;
            this.passhthroughSerializer.serialize((PassthroughMapping)mapping, generator, (SerializerProvider)null);
        }
        generator.writeEndArray();
    }

    private final void writeValue(VisualProperty<Object> vp, Object value, JsonGenerator generator) throws IOException {
        if (value == null) {
            return;
        }
        Class type = vp.getRange().getType();
        if (type == String.class) {
            generator.writeString(value.toString());
        } else if (type == Boolean.class) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (type == Double.class) {
            generator.writeNumber(((Double)value).doubleValue());
        } else if (type == Integer.class) {
            generator.writeNumber(((Integer)value).intValue());
        } else if (type == Long.class) {
            generator.writeNumber(((Long)value).longValue());
        } else if (type == Float.class) {
            generator.writeNumber(((Double)value).doubleValue());
        } else {
            generator.writeString(vp.toSerializableString(value));
        }
    }

    public final String serializeViews(Collection<? extends View<? extends CyIdentifiable>> views, Collection<VisualProperty<?>> visualProperties) throws IOException {
        TreeMap names = new TreeMap();
        for (VisualProperty<?> vp : visualProperties) {
            names.put(vp.getIdString(), vp);
        }
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartArray();
        for (View<? extends CyIdentifiable> view : views) {
            generator.writeStartObject();
            generator.writeNumberField("SUID", ((CyIdentifiable)view.getModel()).getSUID().longValue());
            generator.writeArrayFieldStart("view");
            this.addKeyValuePair(generator, names, view);
            generator.writeEndArray();
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeView(View<? extends CyIdentifiable> view, Collection<VisualProperty<?>> visualProperties) throws IOException {
        TreeMap names = new TreeMap();
        for (VisualProperty<?> vp : visualProperties) {
            names.put(vp.getIdString(), vp);
        }
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartArray();
        this.addKeyValuePair(generator, names, view);
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeSingleVisualProp(View<? extends CyIdentifiable> view, VisualProperty<?> vp) throws IOException {
        TreeMap names = new TreeMap();
        names.put(vp.getIdString(), vp);
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeStringField("visualProperty", vp.getIdString());
        generator.writeFieldName("value");
        this.writeValue(vp, view.getVisualProperty(vp), generator);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    private final void addKeyValuePair(JsonGenerator generator, SortedMap<String, VisualProperty<?>> names, View<? extends CyIdentifiable> view) throws IOException {
        for (String name : names.keySet()) {
            VisualProperty vp = (VisualProperty)names.get(name);
            generator.writeStartObject();
            generator.writeStringField("visualProperty", vp.getIdString());
            generator.writeFieldName("value");
            this.writeValue((VisualProperty<Object>)vp, view.getVisualProperty(vp), generator);
            generator.writeEndObject();
        }
    }

    public final String serializeDependecies(Set<VisualPropertyDependency<?>> dependencies) throws IOException {
        TreeMap names = new TreeMap();
        for (VisualPropertyDependency<?> dep : dependencies) {
            names.put(dep.getIdString(), dep);
        }
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)stream);
        generator.useDefaultPrettyPrinter();
        generator.writeStartArray();
        for (String key : names.keySet()) {
            this.addDependency(generator, (VisualPropertyDependency)names.get(key));
        }
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    private final void addDependency(JsonGenerator generator, VisualPropertyDependency<?> dep) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("visualPropertyDependency", dep.getIdString());
        generator.writeBooleanField("enabled", dep.isDependencyEnabled());
        generator.writeEndObject();
    }
}

