/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import org.cytoscape.model.CyTable;

public class TableSerializer
extends JsonSerializer<CyTable> {
    public Class<CyTable> handledType() {
        return CyTable.class;
    }

    public void serialize(CyTable table, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeNumberField("SUID", table.getSUID().longValue());
        generator.writeStringField("title", table.getTitle());
        generator.writeBooleanField("public", table.isPublic());
        generator.writeStringField("mutable", table.getMutability().name());
        generator.writeStringField("primaryKey", table.getPrimaryKey().getName());
        List rows = table.getAllRows();
        generator.writeObjectField("rows", (Object)rows);
        generator.writeEndObject();
    }
}

