/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class GroupSerializer
extends JsonSerializer<CyGroup> {
    private final CyNetwork network;

    public GroupSerializer(CyNetwork network) {
        this.network = network;
    }

    public Class<CyGroup> handledType() {
        return CyGroup.class;
    }

    public void serialize(CyGroup group, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.useDefaultPrettyPrinter();
        jgen.writeStartObject();
        CyNode groupNode = group.getGroupNode();
        List memberNodes = group.getNodeList();
        List internalEdges = group.getInternalEdgeList();
        Set externalEdges = group.getExternalEdgeList();
        jgen.writeNumberField("SUID", groupNode.getSUID().longValue());
        if (this.network != null) {
            jgen.writeBooleanField("collapsed", group.isCollapsed(this.network));
        }
        jgen.writeArrayFieldStart("nodes");
        for (CyNode node : memberNodes) {
            jgen.writeNumber(node.getSUID().longValue());
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("internal_edges");
        for (CyEdge edge : internalEdges) {
            jgen.writeNumber(edge.getSUID().longValue());
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("external_edges");
        for (CyEdge edge : externalEdges) {
            jgen.writeNumber(edge.getSUID().longValue());
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

