/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;

public class GraphObjectSerializer {
    private static final Pattern REPLACE_INVALID_JS_CHAR_PATTERN = Pattern.compile("^[^a-zA-Z_]+|[^a-zA-Z_0-9]+");

    public final String serializeGraphObject(CyIdentifiable obj, CyRow row) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartObject();
        generator.writeObjectFieldStart("data");
        this.serializeRow(generator, obj, row);
        generator.writeEndObject();
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeRow(CyRow row) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartObject();
        this.serializeSingleRow(generator, row);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeCell(CyRow row, String columnName) throws IOException {
        CyColumn column = row.getTable().getColumn(columnName);
        if (column == null) {
            throw new IOException("No such column: " + columnName);
        }
        Object value = row.get(columnName, column.getType());
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartObject();
        this.serializeCell(generator, column, value);
        generator.writeEndObject();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeAllRows(Collection<CyRow> rows) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartArray();
        for (CyRow row : rows) {
            generator.writeStartObject();
            this.serializeSingleRow(generator, row);
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeColumns(Collection<CyColumn> columns) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        generator.writeStartArray();
        for (CyColumn column : columns) {
            generator.writeStartObject();
            generator.writeStringField("name", column.getName());
            generator.writeStringField("type", column.getType().getSimpleName());
            if (List.class.isAssignableFrom(column.getType())) {
                generator.writeStringField("listType", column.getListElementType().getSimpleName());
            }
            generator.writeBooleanField("immutable", column.isImmutable());
            generator.writeBooleanField("primaryKey", column.isPrimaryKey());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.close();
        result = stream.toString("UTF-8");
        stream.close();
        return result;
    }

    public final String serializeColumnValues(CyColumn column, Collection<Object> values) throws IOException {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        generator = factory.createGenerator((OutputStream)stream);
        try {
            generator.writeStartObject();
            generator.writeStringField("name", column.getName());
            generator.writeFieldName("values");
            generator.writeStartArray();
            for (Object value : values) {
                if (column.getType() == List.class) {
                    this.writeList(column.getListElementType(), (List)value, generator);
                    continue;
                }
                this.writeValue(column.getType(), value, generator);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.close();
            result = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private final void serializeSingleRow(JsonGenerator generator, CyRow row) throws IOException {
        Collection columns = row.getTable().getColumns();
        Map values = row.getAllValues();
        for (CyColumn col : columns) {
            Object value = values.get(col.getName());
            if (value == null) continue;
            Class type = col.getType();
            String columnName = col.getName();
            generator.writeFieldName(this.replaceColumnName(columnName));
            if (type == List.class) {
                this.writeList(col.getListElementType(), (List)value, generator);
                continue;
            }
            this.writeValue(type, value, generator);
        }
    }

    private final void serializeRow(JsonGenerator generator, CyIdentifiable obj, CyRow row) throws IOException {
        Collection columns = row.getTable().getColumns();
        Map values = row.getAllValues();
        if (obj instanceof CyEdge) {
            Long sourceId = ((CyEdge)obj).getSource().getSUID();
            Long targetId = ((CyEdge)obj).getTarget().getSUID();
            generator.writeNumberField("source", sourceId.longValue());
            generator.writeNumberField("target", targetId.longValue());
        } else {
            generator.writeNumberField("id", obj.getSUID().longValue());
        }
        for (CyColumn col : columns) {
            Object value = values.get(col.getName());
            if (value == null) continue;
            Class type = col.getType();
            String columnName = col.getName();
            generator.writeFieldName(this.replaceColumnName(columnName));
            if (type == List.class) {
                this.writeList(col.getListElementType(), (List)value, generator);
                continue;
            }
            this.writeValue(type, value, generator);
        }
    }

    private final void serializeCell(JsonGenerator generator, CyColumn col, Object value) throws IOException {
        Class type = col.getType();
        String columnName = col.getName();
        generator.writeFieldName(this.replaceColumnName(columnName));
        if (type == List.class) {
            this.writeList(col.getListElementType(), (List)value, generator);
        } else {
            this.writeValue(type, value, generator);
        }
    }

    private final void writeList(Class<?> type, List<?> values, JsonGenerator jgen) throws JsonGenerationException, IOException {
        if (values == null) {
            return;
        }
        jgen.writeStartArray();
        for (Object value : values) {
            this.writeValue(type, value, jgen);
        }
        jgen.writeEndArray();
    }

    private final String replaceColumnName(String columnName) {
        return columnName;
    }

    private final void writeValue(Class<?> type, Object value, JsonGenerator generator) throws IOException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        if (type == String.class) {
            generator.writeString(value.toString());
        } else if (type == Boolean.class) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (type == Double.class) {
            generator.writeNumber(((Double)value).doubleValue());
        } else if (type == Integer.class) {
            generator.writeNumber(((Integer)value).intValue());
        } else if (type == Long.class) {
            generator.writeNumber(((Long)value).longValue());
        } else if (type == Float.class) {
            generator.writeNumber(((Double)value).doubleValue());
        }
    }
}

