/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.rest.internal.model.CyPropertyModel;
import org.cytoscape.rest.internal.model.CyPropertyValueModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.task.CyPropertyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Properties"})
@Singleton
@Path(value="/v1/properties")
public class PropertiesResource
extends AbstractResource {
    static final String RESOURCE_URN = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesResource.class);
    static final int NAMESPACE_NOT_FOUND_ERROR = 1;
    static final int NAMESPACE_IS_EMPTY_ERROR = 2;
    static final int PROPERTY_NOT_FOUND_ERROR = 3;
    static final int INVALID_PARAMETER_ERROR = 4;
    @Inject
    protected CyPropertyListener cyPropertyListener;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List available Cytoscape Property namespaces", notes="Returns a list of available Cytoscape Property namespaces")
    public CIResponse<List<String>> getPropertyNamespaceList() {
        return this.ciResponseFactory.getCIResponse(this.cyPropertyListener.getPropertyNames());
    }

    private Properties getProperties(String namespace) {
        if (this.cyPropertyListener.getCyProperty(namespace) == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 1, "Could not find property namespace: " + namespace, logger, null);
        }
        Properties properties = (Properties)this.cyPropertyListener.getCyProperty(namespace).getProperties();
        if (properties == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Property namespace does not contain properties: " + namespace, logger, null);
        }
        return properties;
    }

    @GET
    @Path(value="/{namespace}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a list of Cytoscape Properties for a namespace", notes="Returns the Cytoscape Properties in the namespace specified by the `namespace` parameter.")
    public CIResponse<List<String>> getPropertyList(@ApiParam(value="Cytoscape Property namespace") @PathParam(value="namespace") String namespace) {
        Properties properties = this.getProperties(namespace);
        ArrayList<String> output = new ArrayList<String>();
        output.addAll(properties.stringPropertyNames());
        return this.ciResponseFactory.getCIResponse(output);
    }

    @GET
    @Path(value="/{namespace}/{propertyKey}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a Cytoscape Property", notes="Returns the Cytoscape Property specified by the `namespace` and `propertyKey` parameters.", response=CyPropertyModelResponse.class)
    public Response getProperty(@ApiParam(value="Cytoscape Property namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="Key of the CyProperty") @PathParam(value="propertyKey") String propertyKey) {
        CyPropertyModel output = null;
        Properties properties = this.getProperties(namespace);
        output = new CyPropertyModel();
        if (!properties.containsKey(propertyKey)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Property namespace \"" + namespace + "\" does not contain property: " + propertyKey, logger, null);
        }
        String property = properties.getProperty(propertyKey);
        output.key = propertyKey;
        output.value = property;
        return Response.ok((Object)this.ciResponseFactory.getCIResponse((Object)output)).build();
    }

    @PUT
    @Path(value="/{namespace}/{propertyKey}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Sets a Cytoscape Property", notes="Sets the Cytoscape Property specified by the `namespace` and `propertyKey` parameters.")
    public CIResponse<Object> putProperty(@ApiParam(value="Cytoscape Property namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="Key of the CyProperty") @PathParam(value="propertyKey") String propertyKey, @ApiParam(value="A CyProperty value") CyPropertyValueModel propertyValue) {
        Properties properties = this.getProperties(namespace);
        if (!properties.containsKey(propertyKey)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Property namespace \"" + namespace + "\" does not contain property: " + propertyKey, logger, null);
        }
        properties.setProperty(propertyKey, propertyValue.value);
        return this.ciResponseFactory.getCIResponse(new Object());
    }

    @DELETE
    @Path(value="/{namespace}/{propertyKey}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Deletes a Cytoscape Property", notes="Deletes the Cytoscape Property specified by the `namespace` and `propertyKey` parameters.")
    public CIResponse<Object> deleteProperty(@ApiParam(value="Cytoscape Property namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="Key of the CyProperty") @PathParam(value="propertyKey") String propertyKey) {
        Properties properties = this.getProperties(namespace);
        if (!properties.containsKey(propertyKey)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Property namespace \"" + namespace + "\" does not contain property: " + propertyKey, logger, null);
        }
        properties.remove(propertyKey);
        return this.ciResponseFactory.getCIResponse(new Object());
    }

    @POST
    @Path(value="/{namespace}/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a Cytoscape Property", notes="Creates a Cytoscape Property in the namespace specified by the `namespace` parameter.")
    public CIResponse<Object> postProperty(@ApiParam(value="Cytoscape Property namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="A CyProperty with a key and value") CyPropertyModel propertyValue) {
        Properties properties = this.getProperties(namespace);
        properties.setProperty(propertyValue.key, propertyValue.value);
        return this.ciResponseFactory.getCIResponse(new Object());
    }

    private static class CyPropertyModelResponse
    extends CIResponse<CyPropertyModel> {
        private CyPropertyModelResponse() {
        }
    }
}

