/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.rest.internal.model.SUIDNameModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Networks"})
@Singleton
@Path(value="/v1/networks.names")
public class NetworkNameResource
extends AbstractResource {
    private static final String RESOURCE_URN = "networks";
    private static final Logger logger = LoggerFactory.getLogger(NetworkNameResource.class);

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    @ApiOperation(value="Returns a list of network names with corresponding SUIDs", notes="Returns a list of all networks as names and their corresponding SUIDs.\n\nIf the `column` and `query` parameters are specified, the results will be limited to rows in the network table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.", response=SUIDNameModel.class, responseContainer="List")
    public List<Map<String, Object>> getNetworksNames(@ApiParam(value="The name of the column that will be queried for matches.") @QueryParam(value="column") String column, @ApiParam(value="The value to be matched.") @QueryParam(value="query") String query) {
        Set<CyNetwork> networks;
        if (column == null && query == null) {
            networks = this.networkManager.getNetworkSet();
        } else {
            try {
                networks = this.getNetworksByQuery(7, query, column);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Error executing Network query.", this.getResourceLogger(), e);
            }
        }
        return this.getNetworksAsSimpleList(networks);
    }

    private final List<Map<String, Object>> getNetworksAsSimpleList(Set<CyNetwork> networks) {
        if (networks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> networksList = new ArrayList<Map<String, Object>>();
        for (CyNetwork network : networks) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("SUID", network.getSUID());
            values.put("name", network.getRow((CyIdentifiable)network).get("name", String.class));
            networksList.add(values);
        }
        return networksList;
    }
}

