/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.TableModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/v1/tables")
@Api(tags={"Tables"})
public class GlobalTableResource
extends AbstractResource {
    private static final String RESOURCE_URN = "tables";
    private static final Logger logger = LoggerFactory.getLogger(GlobalTableResource.class);
    @Inject
    @NotNull
    private CyTableFactory tableFactory;
    private final ObjectMapper tableObjectMapper = new ObjectMapper();

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public GlobalTableResource() {
        this.tableObjectMapper.registerModule((Module)new TableModule());
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of global tables", notes="Returns the number of global tables.")
    public CountModel getTableCount() {
        Set globals = this.tableManager.getGlobalTables();
        return new CountModel(Integer.valueOf(globals.size()).longValue());
    }
}

