/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.annotations.Tag;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.resource.CollectionResource;
import org.cytoscape.rest.internal.task.AutomationAppTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/swagger.json")
@Singleton
public class CyRESTSwagger
extends AbstractResource {
    @Inject
    @NotNull
    AutomationAppTracker appTracker;
    private static final String RESOURCE_URN = "swagger";
    private static final Logger logger = LoggerFactory.getLogger(CollectionResource.class);
    private String swaggerDefinition;
    final Set<Class<?>> classes = new HashSet();
    public static final String COMMAND_LINK_PREFIX = "\n\nFor a list of all available commands and their documentation, see the [CyREST Command API](";
    public static final String COMMAND_LINK_POSTFIX = ")";
    private static final String SWAGGER_INFO_DESCRIPTION = "A RESTful service for accessing Cytoscape 3.\n\n";
    public static final String NETWORK_GET_LINK = "[/v1/networks](#!/Networks/getNetworksAsSUID)";
    public static final String NETWORK_VIEWS_LINK = "[/v1/networks/{networkId}/views](#!/Network32Views/getAllNetworkViews)";

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public void addResource(Class<?> clazz) {
        this.classes.add(clazz);
        this.updateSwagger();
    }

    public void removeResource(Class<?> clazz) {
        this.classes.remove(clazz);
        this.updateSwagger();
    }

    public CyRESTSwagger() {
        this.updateSwagger();
    }

    protected void updateSwagger() {
        this.swaggerDefinition = null;
    }

    public boolean isSwaggerDefinitionNull() {
        return this.swaggerDefinition == null;
    }

    protected void buildSwagger() {
        final HashSet classes = new HashSet(this.classes);
        BeanConfig beanConfig = new BeanConfig(){

            public Set<Class<?>> classes() {
                classes.add(CyRESTSwaggerConfig.class);
                return classes;
            }
        };
        beanConfig.setHost("localhost:" + this.cyRESTPort);
        beanConfig.setScan(true);
        beanConfig.setPrettyPrint(true);
        Swagger swagger = beanConfig.getSwagger();
        String automationAppReport = this.appTracker.getMarkdownReport();
        swagger.getInfo().setDescription(SWAGGER_INFO_DESCRIPTION + automationAppReport);
        this.wrapCIResponses(swagger);
        this.addCommandLinks(swagger);
        try {
            Json.mapper().enable(SerializationFeature.INDENT_OUTPUT);
            this.swaggerDefinition = Json.mapper().writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void wrapCIResponses(Swagger swagger) {
        Map paths = swagger.getPaths();
        if (paths != null) {
            for (Map.Entry pathEntry : paths.entrySet()) {
                try {
                    Map operationMap = ((io.swagger.models.Path)pathEntry.getValue()).getOperationMap();
                    for (Map.Entry operationEntry : operationMap.entrySet()) {
                        Map map;
                        Object ciExtension = ((Operation)operationEntry.getValue()).getVendorExtensions().get("x-ci-extension");
                        if (ciExtension == null || !(ciExtension instanceof Map) || !"true".equals((map = (Map)ciExtension).get("CIWrapping"))) continue;
                        for (Map.Entry responseEntry : ((Operation)operationEntry.getValue()).getResponses().entrySet()) {
                            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                            propertyMap.put("data", ((Response)responseEntry.getValue()).getSchema());
                            RefProperty errorProperty = new RefProperty("#/definitions/CIError");
                            propertyMap.put("errors", new ArrayProperty((Property)errorProperty));
                            ObjectProperty ciProperty = new ObjectProperty(propertyMap);
                            ((Response)responseEntry.getValue()).setSchema((Property)ciProperty);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getCommandLink() {
        try {
            String url = "http://localhost:" + this.cyRESTPort + "/v1/swaggerUI/swagger-ui/index.html?url=" + URLEncoder.encode("http://localhost:" + this.cyRESTPort + "/v1/commands/swagger.json", "UTF-8");
            return COMMAND_LINK_PREFIX + url + COMMAND_LINK_POSTFIX;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "\n\nUnable to make a hyperlink to the CyREST Command API";
        }
    }

    private void addCommandLinks(Swagger swagger) {
        Map paths = swagger.getPaths();
        if (paths != null) {
            for (Map.Entry pathEntry : paths.entrySet()) {
                Map operationMap = ((io.swagger.models.Path)pathEntry.getValue()).getOperationMap();
                for (Map.Entry operationEntry : operationMap.entrySet()) {
                    if (((Operation)operationEntry.getValue()).getTags() == null || !((Operation)operationEntry.getValue()).getTags().contains("Commands")) continue;
                    Object description = ((Operation)operationEntry.getValue()).getDescription();
                    if (description == null) {
                        description = "";
                    }
                    description = (String)description + this.getCommandLink();
                    ((Operation)operationEntry.getValue()).setDescription((String)description);
                }
            }
        }
    }

    @Produces(value={"application/json"})
    @GET
    public String get() {
        if (this.swaggerDefinition == null) {
            this.buildSwagger();
        }
        return this.swaggerDefinition;
    }

    @SwaggerDefinition(info=@Info(description="A RESTful service for accessing Cytoscape 3.", version="V2.0.0", title="CyREST API"), basePath="", consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"}, schemes={SwaggerDefinition.Scheme.HTTP}, tags={@Tag(name="Collections"), @Tag(name="Commands"), @Tag(name="Cytoscape System"), @Tag(name="Groups"), @Tag(name="Layouts"), @Tag(name="Networks"), @Tag(name="Network Views"), @Tag(name="Properties"), @Tag(name="REST Service"), @Tag(name="Session"), @Tag(name="Tables"), @Tag(name="User Interface"), @Tag(name="Visual Properties"), @Tag(name="Visual Styles")}, externalDocs=@ExternalDocs(value="Cytoscape", url="http://cytoscape.org/"))
    public static class CyRESTSwaggerConfig
    implements ReaderListener {
        public static final String SESSION_TAG = "Session";
        public static final String APPS_TAG = "Apps";
        public static final String USER_INTERFACE_TAG = "User Interface";
        public static final String NETWORKS_TAG = "Networks";
        public static final String TABLES_TAG = "Tables";
        public static final String COMMANDS_TAG = "Commands";
        public static final String REST_SERVICE_TAG = "REST Service";
        public static final String LAYOUTS_TAG = "Layouts";
        public static final String NETWORK_VIEWS_TAG = "Network Views";
        public static final String PROPERTIES_TAG = "Properties";
        public static final String VISUAL_PROPERTIES_TAG = "Visual Properties";
        public static final String VISUAL_STYLES_TAG = "Visual Styles";
        public static final String GROUPS_TAG = "Groups";
        public static final String COLLECTIONS_TAG = "Collections";
        public static final String CYTOSCAPE_SYSTEM_TAG = "Cytoscape System";

        public void beforeScan(Reader arg0, Swagger arg1) {
        }

        public void afterScan(Reader reader, Swagger swagger) {
        }
    }
}

