/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.datamapper;

import com.fasterxml.jackson.databind.JsonNode;

public class MapperUtil {
    public static final Class<?> getColumnClass(String type, boolean treatNumberAsDouble) {
        if (type.equals(Double.class.getSimpleName())) {
            return Double.class;
        }
        if (type.equals(Long.class.getSimpleName())) {
            return Long.class;
        }
        if (type.equals(Integer.class.getSimpleName())) {
            return Integer.class;
        }
        if (type.equals(Float.class.getSimpleName())) {
            return Float.class;
        }
        if (type.equals(Boolean.class.getSimpleName())) {
            return Boolean.class;
        }
        if (type.equals(String.class.getSimpleName())) {
            return String.class;
        }
        if (type.equals(Number.class.getSimpleName())) {
            return treatNumberAsDouble ? Double.class : Number.class;
        }
        return null;
    }

    public static final Object getRawValue(String queryString, Class<?> type) {
        Object raw = queryString;
        if (type == Boolean.class) {
            raw = Boolean.parseBoolean(queryString);
        } else if (type == Double.class) {
            raw = Double.parseDouble(queryString);
        } else if (type == Integer.class) {
            raw = Integer.parseInt(queryString);
        } else if (type == Long.class) {
            raw = Long.parseLong(queryString);
        } else if (type == Float.class) {
            raw = Float.valueOf(Float.parseFloat(queryString));
        }
        return raw;
    }

    public static final Object getValue(JsonNode value, Class<?> type) {
        if (type == String.class) {
            return value.asText();
        }
        if (type == Boolean.class || type.getSimpleName() == "boolean") {
            return value.asBoolean();
        }
        if (type == Double.class || type.getSimpleName() == "double") {
            return value.asDouble();
        }
        if (type == Integer.class || type.getSimpleName() == "int") {
            return value.asInt();
        }
        if (type == Long.class || type.getSimpleName() == "long") {
            return value.asLong();
        }
        if (type == Float.class || type.getSimpleName() == "float") {
            return value.asDouble();
        }
        return null;
    }
}

