/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.commands.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.commands.handlers.MessageHandler;
import org.cytoscape.rest.internal.commands.resources.CommandResourceTaskObserver;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.slf4j.Logger;

class JSONResultTaskObserver
extends CommandResourceTaskObserver
implements TaskObserver {
    private final Logger logger;
    CIErrorFactory ciErrorFactory;
    List<CIError> ciErrors = new ArrayList<CIError>();
    boolean succeeded = false;
    final List<String> jsonResultStrings = new ArrayList<String>();

    JSONResultTaskObserver(MessageHandler messageHandler, CIErrorFactory ciErrorFactory, Logger logger) {
        super(messageHandler);
        this.ciErrorFactory = ciErrorFactory;
        this.logger = logger;
    }

    public void taskFinished(ObservableTask task) {
        Class jsonResultClass = null;
        List classList = task.getResultClasses();
        if (classList != null) {
            for (Class clazz : classList) {
                if (!JSONResult.class.isAssignableFrom(clazz)) continue;
                jsonResultClass = clazz;
            }
        }
        if (jsonResultClass != null) {
            JSONResult jsonResult = (JSONResult)task.getResults(jsonResultClass);
            this.jsonResultStrings.add(jsonResult.getJSON());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allFinished(FinishStatus finishStatus) {
        CIError ciError;
        if (finishStatus.getType() == FinishStatus.Type.CANCELLED) {
            if (finishStatus.getTask() != null && finishStatus.getTask() instanceof TunableValidator) {
                StringBuilder stringBuilder = new StringBuilder();
                ciError = ((TunableValidator)finishStatus.getTask()).getValidationState((Appendable)stringBuilder) == TunableValidator.ValidationState.INVALID ? this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI("handle-json-command", 2), "Task Cancelled. Could not validate Tunable inputs: " + stringBuilder.toString()) : this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI("handle-json-command", 2), "Task Cancelled. All inputs were validated.");
            } else {
                ciError = this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI("handle-json-command", 2), "Task Cancelled.");
            }
            this.ciErrors.add(ciError);
        } else if (finishStatus.getType() == FinishStatus.Type.FAILED) {
            if (finishStatus.getException() != null) {
                ciError = this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI("handle-json-command", 2), finishStatus.getException().getMessage() == null ? finishStatus.getException().toString() : finishStatus.getException().getMessage());
                finishStatus.getException().printStackTrace(System.err);
            } else {
                ciError = this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI("handle-json-command", 2), "Task Failed with No Exception: " + (finishStatus.getTask() != null ? finishStatus.getTask().getClass().getName() : "no attached class"));
            }
            this.ciErrors.add(ciError);
        } else if (finishStatus.getType() == FinishStatus.Type.SUCCEEDED) {
            this.succeeded |= true;
        }
        JSONResultTaskObserver jSONResultTaskObserver = this;
        synchronized (jSONResultTaskObserver) {
            this.finished = true;
            this.notify();
        }
    }
}

