/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.commands.resources;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.rest.internal.CIErrorFactoryImpl;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.commands.handlers.MessageHandler;
import org.cytoscape.rest.internal.commands.handlers.TextHTMLHandler;
import org.cytoscape.rest.internal.commands.handlers.TextPlainHandler;
import org.cytoscape.rest.internal.commands.resources.CommandResourceTaskObserver;
import org.cytoscape.rest.internal.commands.resources.JSONResultTaskObserver;
import org.cytoscape.rest.internal.commands.resources.StringResultTaskObserver;
import org.cytoscape.rest.internal.task.LogLocation;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Commands"})
@Singleton
@Path(value="/v1/commands")
public class CommandResource {
    private static final Logger logger = LoggerFactory.getLogger(CommandResource.class);
    @Inject
    @LogLocation
    protected URI logLocation;
    @Inject
    @NotNull
    private AvailableCommands available;
    @Inject
    @NotNull
    private CommandExecutorTaskFactory ceTaskFactory;
    @Inject
    @NotNull
    private SynchronousTaskManager<Object> taskManager;
    @Inject
    protected CIResponseFactory ciResponseFactory;
    @Inject
    protected CIErrorFactory ciErrorFactory;
    @Inject
    protected CIExceptionFactory ciExceptionFactory;
    public static final String JSON_COMMAND_RESOURCE_URI = "handle-json-command";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="List all available command namespaces", notes="Method handling HTTP GET requests to enumerate all namespaces. The returned list will be sent to the client as \"text/plain\" media type.")
    public String enumerateNamespaces() {
        TextPlainHandler handler = new TextPlainHandler();
        List namespaces = this.available.getNamespaces();
        handler.appendCommand("Available namespaces:");
        for (String namespace : namespaces) {
            handler.appendMessage("  " + namespace);
        }
        return handler.getMessageString();
    }

    @GET
    @Produces(value={"text/html"})
    @ApiOperation(value="List all available command namespaces", notes="Method handling HTTP GET requests to enumerate all namespaces. The returned list will be sent to the client as \"text/html\" media type.")
    public String enumerateNamespacesHtml() {
        TextHTMLHandler handler = new TextHTMLHandler();
        List namespaces = this.available.getNamespaces();
        handler.appendCommand("Available namespaces:");
        for (String namespace : namespaces) {
            handler.appendMessage(namespace);
        }
        return handler.getMessageString();
    }

    @GET
    @Path(value="/{namespace}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="List all available commands in a namespace", notes="Method to enumerate all commands for a given namespace. The returned list will be sent to the client as \"text/plain\" media type.")
    public String enumerateCommands(@PathParam(value="namespace") String namespace) {
        TextPlainHandler handler = new TextPlainHandler();
        List commands = this.available.getCommands(namespace);
        if (commands == null || commands.size() == 0) {
            throw new CommandWebApplicationException(404);
        }
        handler.appendCommand("Available commands for '" + namespace + "':");
        for (String command : commands) {
            handler.appendMessage("  " + command);
        }
        return handler.getMessageString();
    }

    @GET
    @Path(value="/{namespace}")
    @Produces(value={"text/html"})
    @ApiOperation(value="List all available commands in a namespace", notes="Method to enumerate all commands for a given namespace. The returned list will be sent to the client as \"text/html\" media type.")
    public String enumerateHTMLCommands(@PathParam(value="namespace") String namespace) {
        TextHTMLHandler handler = new TextHTMLHandler();
        List commands = this.available.getCommands(namespace);
        if (commands == null || commands.size() == 0) {
            throw new CommandWebApplicationException(404);
        }
        handler.appendCommand("Available commands for '" + namespace + "':");
        for (String command : commands) {
            handler.appendMessage("  " + command);
        }
        return handler.getMessageString();
    }

    @GET
    @Path(value="/{namespace}/{command}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Execute a command or list its arguments", notes="Method to enumerate all arguments for a given namespace and command or execute a namespace and command if query strings are provided.\n\nReturns a list of arguments as text/plain or the results of executing the command.")
    public String handleCommand(@ApiParam(value="Command Namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="Command Name") @PathParam(value="command") String command, @Context UriInfo uriInfo) {
        TextPlainHandler handler = new TextPlainHandler();
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        return this.handleCommand(namespace, command, (MultivaluedMap<String, String>)queryParameters, handler);
    }

    @GET
    @Path(value="/{namespace}/{command}")
    @Produces(value={"text/html"})
    @ApiOperation(value="Execute a command or list its arguments", notes="Method to enumerate all arguments for a given namespace and command or execute a namespace and command if query strings are provided.\n\n###No Query String Execution\n\n```\n/v1/commands/edge/list\n```\n\nReturns a list of arguments as text/html or the results of executing the command if no arguments are available.\n\n###Execution with Query Strings\n\n```\n/v1/commands/edge/list?network=%22current%22\n```\n\nReturns the results of executing the command.\n\nCommands without JSON compatibility will only be accessible through this style of endpoint, and will also have an explicit GET resource in the Swagger documentation.\n\nCommands with JSON compatibility are primarily available as POST requests and will have an explicit POST resource in the Swagger documentation. These commands can also be accessed via GET, and any parameters in the POST body can be entered in the request path.\n\nA command accessed via a POST request with a message body like the following:\n\n```\n{\"network\": \"current\"}\n```\n\nCan be also accessed via a GET request with the same parameters passed in the path: \n\n```\n/v1/commands/edge/list?network=%22current%22\n```")
    public String handleHTMLCommand(@ApiParam(value="Command Namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="Command Name") @PathParam(value="command") String command, @Context UriInfo uriInfo) {
        TextHTMLHandler handler = new TextHTMLHandler();
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        return this.handleCommand(namespace, command, (MultivaluedMap<String, String>)queryParameters, handler);
    }

    @POST
    @Path(value="/{namespace}/{command}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute Command with JSON output", hidden=true)
    public Response handleJSONCommand(@PathParam(value="namespace") String namespace, @PathParam(value="command") String command, Map<String, Object> queryParameters) {
        TextPlainHandler handler = new TextPlainHandler();
        JSONResultTaskObserver jsonTaskObserver = new JSONResultTaskObserver(handler, this.ciErrorFactory, logger);
        try {
            this.executeCommand(namespace, command, queryParameters, handler, jsonTaskObserver);
            return Response.status((int)(jsonTaskObserver.ciErrors.isEmpty() ? 200 : 500)).entity((Object)this.buildCIResult(namespace, command, jsonTaskObserver, handler)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String buildCIResult(String namespace, String command, JSONResultTaskObserver jsonTaskObserver, MessageHandler messageHandler) {
        ArrayList<CIError> ciErrorList = new ArrayList<CIError>(jsonTaskObserver.ciErrors);
        if (!jsonTaskObserver.succeeded) {
            ciErrorList.add(this.ciErrorFactory.getCIError(Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), CyRESTConstants.getErrorURI(JSON_COMMAND_RESOURCE_URI, 2), "Successful response was not returned."));
        }
        return CommandResource.getJSONResponse(jsonTaskObserver.jsonResultStrings, jsonTaskObserver.ciErrors, this.logLocation);
    }

    private final String handleCommand(String namespace, String command, MultivaluedMap<String, String> queryParameters, MessageHandler handler) throws WebApplicationException {
        List args = this.available.getArguments(namespace, command);
        if (queryParameters != null && queryParameters.size() > 0 || args == null || args.size() == 0) {
            return this.executeCommand(namespace, command, queryParameters, handler);
        }
        handler.appendCommand("Available arguments for '" + namespace + " " + command + "':");
        for (String arg : args) {
            handler.appendMessage("  " + arg);
        }
        return handler.getMessageString();
    }

    private final String executeCommand(String namespace, String command, MultivaluedMap<String, String> args, MessageHandler handler) throws WebApplicationException {
        List commands = this.available.getCommands(namespace);
        if (commands == null || commands.size() == 0) {
            throw new CustomNotFoundException("Error: no such namespace: '" + namespace + "'");
        }
        boolean nocom = true;
        for (String com : commands) {
            if (!com.equalsIgnoreCase(command)) continue;
            nocom = false;
            break;
        }
        if (nocom) {
            throw new CustomNotFoundException("Error: no such command: '" + command + "'");
        }
        List argList = this.available.getArguments(namespace, command);
        HashMap<String, Object> modifiedSettings = new HashMap<String, Object>();
        for (String inputArg : args.keySet()) {
            boolean found = false;
            for (String arg : argList) {
                String[] bareArg = arg.split("=");
                if (!bareArg[0].equalsIgnoreCase(inputArg)) continue;
                found = true;
                modifiedSettings.put(bareArg[0], this.stripQuotes((String)args.getFirst((Object)inputArg)));
                break;
            }
            if (found) continue;
            throw new CustomNotFoundException("Error: can't find argument '" + inputArg + "'");
        }
        StringResultTaskObserver taskObserver = new StringResultTaskObserver(handler);
        return this.executeCommand(namespace, command, modifiedSettings, handler, taskObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String executeCommand(String namespace, String command, Map<String, Object> args, MessageHandler handler, CommandResourceTaskObserver taskObserver) throws WebApplicationException {
        this.taskManager.execute(this.ceTaskFactory.createTaskIterator(namespace, command, args, (TaskObserver)taskObserver), (TaskObserver)taskObserver);
        CommandResourceTaskObserver commandResourceTaskObserver = taskObserver;
        synchronized (commandResourceTaskObserver) {
            try {
                while (!taskObserver.isFinished()) {
                    taskObserver.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String messages = taskObserver.getMessageHandler().getMessageString();
        if (taskObserver.getTaskException() != null) {
            throw taskObserver.getTaskException();
        }
        return messages;
    }

    private final String stripQuotes(String quotedString) {
        String tqString = quotedString.trim();
        if (tqString.startsWith("\"") && tqString.endsWith("\"")) {
            return tqString.substring(1, tqString.length() - 1);
        }
        return tqString;
    }

    public static String getJSONResponse(List<String> jsonResultStrings, List<CIError> errors, URI logLocation) {
        boolean jsonValid;
        String NO_DATA_RESPONSE = "{\n \"data\": {},\n \"errors\":";
        StringBuilder jsonResultBuilder = new StringBuilder();
        Gson gson = new Gson();
        try {
            for (String jsonResultString : jsonResultStrings) {
                gson.fromJson(jsonResultString, Object.class);
            }
            jsonValid = true;
        }
        catch (JsonSyntaxException e) {
            jsonValid = false;
            logger.error(e.getMessage(), (Throwable)e);
            CIErrorFactoryImpl ciErrorFactory = new CIErrorFactoryImpl(logLocation);
            CIError jsonSyntaxError = ciErrorFactory.getCIError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), CyRESTConstants.getErrorURI(JSON_COMMAND_RESOURCE_URI, 3), "Task returned invalid json.");
            errors.add(jsonSyntaxError);
        }
        if (jsonValid) {
            if (jsonResultStrings.size() == 0) {
                jsonResultBuilder.append("{\n \"data\": {},\n \"errors\":");
            } else if (jsonResultStrings.size() == 1) {
                jsonResultBuilder.append("{\n \"data\": ");
                String jsonResult = jsonResultStrings.get(0);
                jsonResultBuilder.append(jsonResult);
                jsonResultBuilder.append(",\n \"errors\":");
            } else {
                jsonResultBuilder.append("{\n \"data\": [ ");
                for (int i = 0; i < jsonResultStrings.size(); ++i) {
                    String jsonResult = jsonResultStrings.get(i);
                    jsonResultBuilder.append(jsonResult);
                    if (i == jsonResultStrings.size() - 1) continue;
                    jsonResultBuilder.append(",");
                }
                jsonResultBuilder.append("],\n \"errors\":");
            }
        } else {
            jsonResultBuilder.append("{\n \"data\": {},\n \"errors\":");
        }
        if (!errors.isEmpty()) {
            jsonResultBuilder.append(gson.toJson(errors));
        } else {
            jsonResultBuilder.append("[]");
        }
        jsonResultBuilder.append("\n}");
        return jsonResultBuilder.toString();
    }

    public class CustomNotFoundException
    extends WebApplicationException {
        public CustomNotFoundException() {
            super(404);
        }

        public CustomNotFoundException(String message) {
            super(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).type("text/plain").build());
        }
    }

    public final class CommandWebApplicationException
    extends WebApplicationException {
        public CommandWebApplicationException(int status) {
            super(status);
        }
    }
}

