/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal.heuristics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.diagnostics.internal.heuristics.AbstractHeuristic;

public abstract class WmicHeuristic<T>
extends AbstractHeuristic<T> {
    protected String getValue(String alias, String key) throws IOException {
        if (!this.commandExists("wmic")) {
            return null;
        }
        String output = this.runAndGetOutput("wmic", alias, "get", key);
        String[] lines = output.split("\n");
        if (lines.length < 3) {
            return null;
        }
        return lines[2];
    }

    protected Map<String, String> getValues(String alias, String ... keys) throws IOException {
        if (!this.commandExists("wmic")) {
            return Collections.emptyMap();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("wmic");
        arguments.add(alias);
        if (keys.length > 0) {
            arguments.add("get");
            arguments.add(this.join(",", keys));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String output = this.runAndGetOutput(arguments.toArray(new String[arguments.size()]));
        if (output == null) {
            return Collections.emptyMap();
        }
        String[] lines = output.split("\n");
        if (lines.length < 3) {
            return Collections.emptyMap();
        }
        String[] keyNames = lines[0].split("\t");
        String[] values = lines[2].split("\t");
        for (int i = 0; i < keyNames.length; ++i) {
            result.put(keyNames[i], values[i]);
        }
        return result;
    }

    protected Long parseMemory(String data) {
        Long value = this.convert(data, Long.class);
        if (value == null) {
            return null;
        }
        return value * 1024L;
    }

    public static class OSName
    extends WmicHeuristic<String> {
        @Override
        public String computeValue() throws IOException {
            return this.getValue("os", "caption");
        }
    }

    public static class FreeSwap
    extends WmicHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemory(this.getValue("os", "FreeVirtualMemory"));
        }
    }

    public static class TotalSwap
    extends WmicHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemory(this.getValue("os", "TotalVirtualMemorySize"));
        }
    }

    public static class FreeMemory
    extends WmicHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemory(this.getValue("os", "FreePhysicalMemory"));
        }
    }

    public static class TotalMemory
    extends WmicHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemory(this.getValue("os", "TotalVisibleMemorySize"));
        }
    }

    public static class ProcessorName
    extends WmicHeuristic<String> {
        @Override
        public String computeValue() throws IOException {
            return this.getValue("cpu", "name");
        }
    }
}

