/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.logging.log4j.util.Strings;
import org.cytoscape.cg.internal.util.VisualPropertyIconFactory;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

class URLImportPanel
extends JPanel {
    private static final int PREVIEW_BORDER_WIDTH = 1;
    private static final int PREVIEW_PAD = 5;
    private JTextField urlTextField;
    private JLabel msgIconLabel;
    private JLabel msgLabel;
    private JLabel previewImgLabel;
    private AbstractURLImageCustomGraphics image;
    private boolean duplicateImage;
    private DebounceTimer urlDebouncer = new DebounceTimer(500);
    private DebounceTimer resizeDebouncer = new DebounceTimer(250);
    private boolean adjusting;
    private final CyServiceRegistrar serviceRegistrar;

    URLImportPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
        JLabel urlLabel = new JLabel("Image URL:");
        JLabel previewLabel = new JLabel("Preview:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(urlLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getUrlTextField(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.getMsgIconLabel()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getMsgLabel(), -1, -1, Short.MAX_VALUE)))).addComponent(previewLabel).addComponent(this.getPreviewImgLabel(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(urlLabel).addComponent(this.getUrlTextField())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getMsgIconLabel()).addComponent(this.getMsgLabel(), this.getMsgLabel().getPreferredSize().height, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getPreviewImgLabel(), 320, 320, Short.MAX_VALUE));
    }

    AbstractURLImageCustomGraphics getImage() {
        return this.duplicateImage ? null : this.image;
    }

    private void setImage(AbstractURLImageCustomGraphics image) {
        if (!Objects.equal((Object)this.image, (Object)image)) {
            AbstractURLImageCustomGraphics oldValue = this.image;
            this.image = image;
            this.firePropertyChange("image", oldValue, image);
        }
    }

    boolean isDuplicateImage() {
        return this.duplicateImage;
    }

    private void setDuplicateImage(boolean duplicateImage) {
        if (this.duplicateImage != duplicateImage) {
            this.duplicateImage = duplicateImage;
            this.firePropertyChange("duplicateImage", !duplicateImage, duplicateImage);
        }
    }

    JTextField getUrlTextField() {
        if (this.urlTextField == null) {
            this.urlTextField = new JTextField();
            this.urlTextField.setToolTipText("The address of the image (JPEG, PNG, GIF, TIFF, SVG) on the Internet");
            this.urlTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.maybeLoadImage();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.maybeLoadImage();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                private void maybeLoadImage() {
                    String text = URLImportPanel.this.urlTextField.getText();
                    URLImportPanel.this.resetPreview(!text.isBlank());
                    if (text.isBlank()) {
                        URLImportPanel.this.updateErrorMessage(-1, null, null);
                    } else {
                        URLImportPanel.this.urlDebouncer.debounce(() -> URLImportPanel.this.loadImage(text));
                    }
                }
            });
        }
        return this.urlTextField;
    }

    JLabel getMsgIconLabel() {
        if (this.msgIconLabel == null) {
            this.msgIconLabel = new JLabel(" ");
            this.msgIconLabel.setHorizontalTextPosition(0);
            this.msgIconLabel.setVisible(false);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.msgIconLabel});
        }
        return this.msgIconLabel;
    }

    JLabel getMsgLabel() {
        if (this.msgLabel == null) {
            this.msgLabel = new JLabel(" ");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.msgLabel});
        }
        return this.msgLabel;
    }

    JLabel getPreviewImgLabel() {
        if (this.previewImgLabel == null) {
            this.previewImgLabel = new JLabel();
            this.previewImgLabel.setOpaque(true);
            this.previewImgLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground"), 1));
            this.previewImgLabel.setHorizontalAlignment(0);
            this.previewImgLabel.setHorizontalTextPosition(0);
            this.previewImgLabel.setForeground(UIManager.getColor("Separator.foreground"));
            this.previewImgLabel.setFont(this.previewImgLabel.getFont().deriveFont(1, 16.0f));
            this.previewImgLabel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (URLImportPanel.this.image != null && !URLImportPanel.this.adjusting) {
                        URLImportPanel.this.resetPreview(false);
                        URLImportPanel.this.resizeDebouncer.debounce(() -> URLImportPanel.this.updatePreview());
                    }
                }
            });
        }
        return this.previewImgLabel;
    }

    private void loadImage(String urlStr) {
        urlStr = this.normalizeURL(urlStr);
        this.setImage(null);
        int msgType = -1;
        String msg = null;
        String msgDesc = null;
        if (!Strings.isBlank((String)urlStr)) {
            URL url = null;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                msgType = 0;
                msg = "Invalid URL";
                msgDesc = e.getMessage();
            }
            if (url != null) {
                CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
                CyCustomGraphics cg = manager.getCustomGraphicsBySourceURL(url);
                if (cg == null) {
                    this.setDuplicateImage(false);
                    Long id = manager.getNextAvailableID();
                    try {
                        this.setImage(CustomGraphicsUtil.isSVG(url) ? new SVGCustomGraphics(id, url) : new BitmapCustomGraphics(id, url));
                    }
                    catch (Exception e) {
                        msgType = 0;
                        msg = "Invalid Image";
                        msgDesc = e.getMessage();
                    }
                } else {
                    this.setDuplicateImage(true);
                    AbstractURLImageCustomGraphics img = cg instanceof AbstractURLImageCustomGraphics ? (AbstractURLImageCustomGraphics)cg : null;
                    this.setImage(img);
                    msgType = 1;
                    msg = "Duplicate Image";
                    msgDesc = "This image has been imported before";
                }
            }
        }
        this.updatePreview();
        this.updateErrorMessage(msgType, msg, msgDesc);
    }

    private String normalizeURL(String urlStr) {
        if (((String)(urlStr = ((String)urlStr).trim())).startsWith("/")) {
            urlStr = "file:" + (String)urlStr;
        } else if (((String)urlStr).startsWith("file://")) {
            urlStr = ((String)urlStr).replaceFirst("//", "/");
        } else if (((String)urlStr).startsWith("www.")) {
            urlStr = "https://" + (String)urlStr;
        }
        return urlStr;
    }

    private void updateErrorMessage(int msgType, String msg, String description) {
        Color fg = LookAndFeelUtil.getInfoColor();
        TextIcon icon = null;
        if (msg != null) {
            String iconTxt = "\uf05a";
            if (msgType == 2) {
                iconTxt = "\uf071";
                fg = LookAndFeelUtil.getWarnColor();
            } else if (msgType == 0) {
                iconTxt = "\uf071";
                fg = LookAndFeelUtil.getErrorColor();
            }
            Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f);
            icon = new TextIcon(iconTxt, iconFont, 14, 14);
        }
        this.getMsgIconLabel().setForeground(fg);
        this.getMsgIconLabel().setIcon((Icon)icon);
        this.getMsgLabel().setForeground(fg);
        this.getMsgLabel().setText(msg);
        this.getMsgLabel().setToolTipText(description);
        this.getMsgIconLabel().setVisible(msg != null);
        this.getMsgIconLabel().setToolTipText(description);
    }

    private void resetPreview(boolean loading) {
        this.getPreviewImgLabel().setIcon(null);
        this.getPreviewImgLabel().setText(loading ? "Loading..." : "");
    }

    private void updatePreview() {
        Icon icon = null;
        if (this.image != null) {
            int totalPad = 12;
            int w = this.getPreviewImgLabel().getWidth() - totalPad;
            int h = this.getPreviewImgLabel().getHeight() - totalPad;
            if (w > 0 && h > 0) {
                icon = VisualPropertyIconFactory.createIcon(this.image, w, h);
            }
        }
        this.getPreviewImgLabel().setText("");
        this.getPreviewImgLabel().setIcon(icon);
    }
}

