/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.cytoscape.cg.internal.util.ImageUtil;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.util.URLImportPanel;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

class LoadImageDialog
extends JDialog {
    private static final String IMG_FILES_DESCRIPTION = "Image file (PNG, GIF, JPEG or SVG)";
    private static final String[] IMG_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "gif", "svg"};
    private JTabbedPane tabbedPane;
    private JFileChooser fileChooser;
    private URLImportPanel urlImportPanel;
    private JButton okButton;
    private JButton cancelButton;
    private final List<AbstractURLImageCustomGraphics> images = new ArrayList<AbstractURLImageCustomGraphics>();
    private final CyServiceRegistrar serviceRegistrar;

    LoadImageDialog(Window owner, CyServiceRegistrar serviceRegistrar) {
        super(owner, "Add Images", Dialog.ModalityType.APPLICATION_MODAL);
        this.serviceRegistrar = serviceRegistrar;
        this.init();
        this.pack();
    }

    List<AbstractURLImageCustomGraphics> getImages() {
        return this.images;
    }

    void init() {
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton());
        JPanel contents = new JPanel();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        hGroup.addComponent(this.getTabbedPane());
        vGroup.addComponent(this.getTabbedPane(), -1, -1, Short.MAX_VALUE);
        hGroup.addComponent(buttonPanel);
        vGroup.addComponent(buttonPanel, -2, -1, -2);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getOkButton(), this.getCancelButton()});
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getOkButton().getAction(), (Action)this.getCancelButton().getAction());
        this.getRootPane().setDefaultButton(this.getOkButton());
        this.getContentPane().add(contents);
    }

    JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            this.tabbedPane.addTab("From File", this.getFileChooser());
            this.tabbedPane.addTab("From URL", this.getUrlImportPanel());
        }
        return this.tabbedPane;
    }

    URLImportPanel getUrlImportPanel() {
        if (this.urlImportPanel == null) {
            this.urlImportPanel = new URLImportPanel(this.serviceRegistrar);
            this.urlImportPanel.addPropertyChangeListener("image", evt -> this.updateOkButton());
            this.urlImportPanel.addPropertyChangeListener("duplicateImage", evt -> this.updateOkButton());
        }
        return this.urlImportPanel;
    }

    JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setCurrentDirectory(null);
            this.fileChooser.setDialogTitle("");
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setMultiSelectionEnabled(true);
            FileNameExtensionFilter filter = new FileNameExtensionFilter(IMG_FILES_DESCRIPTION, IMG_EXTENSIONS);
            this.fileChooser.setFileFilter(filter);
            this.fileChooser.addChoosableFileFilter(filter);
            this.fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", evt -> this.updateOkButton());
        }
        return this.fileChooser;
    }

    JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoadImageDialog.this.loadImages();
                    LoadImageDialog.this.dispose();
                }
            });
            this.okButton.setEnabled(false);
        }
        return this.okButton;
    }

    JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoadImageDialog.this.images.clear();
                    LoadImageDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private void loadImages() {
        AbstractURLImageCustomGraphics cg;
        Component selectedComp = this.getTabbedPane().getSelectedComponent();
        if (selectedComp == this.getFileChooser()) {
            List<AbstractURLImageCustomGraphics> newImages;
            File[] files = this.fileChooser.getSelectedFiles();
            if (files != null && files.length > 0 && !(newImages = ImageUtil.loadImageCustomGraphics(files, (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class))).isEmpty()) {
                this.images.addAll(newImages);
            }
        } else if (selectedComp == this.getUrlImportPanel() && (cg = this.getUrlImportPanel().getImage()) != null) {
            this.images.add(cg);
        }
    }

    private void updateOkButton() {
        Component selectedComp = this.getTabbedPane().getSelectedComponent();
        if (selectedComp == this.getFileChooser()) {
            File[] files = this.fileChooser.getSelectedFiles();
            this.getOkButton().setEnabled(files != null && files.length > 0);
        } else if (selectedComp == this.getUrlImportPanel()) {
            AbstractURLImageCustomGraphics cg = this.getUrlImportPanel().getImage();
            this.getOkButton().setEnabled(cg != null);
        }
    }
}

