/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.cg.internal.util.ImageUtil;
import org.cytoscape.cg.internal.util.ViewUtil;
import org.cytoscape.cg.internal.util.VisualPropertyIconFactory;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CGComparator;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.cytoscape.cg.util.LoadImageDialog;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCustomGraphicsSelector
extends JPanel {
    private static final int IMAGE_WIDTH = 120;
    private static final int IMAGE_HEIGHT = 68;
    private static final int ITEM_BORDER_WIDTH = 1;
    private static final int ITEM_MARGIN = 2;
    private static final int ITEM_PAD = 2;
    final Color BG_COLOR;
    final Color FG_COLOR;
    final Color SEL_BG_COLOR;
    final Color SEL_FG_COLOR;
    final Color FOCUS_BORDER_COLOR;
    final Color FOCUS_OVERLAY_COLOR;
    final Color BORDER_COLOR;
    private boolean firingActionEvent;
    private String actionCommand = "imageCustomGraphicsSelectorChanged";
    private JButton addBtn;
    private JToggleButton editBtn;
    private JPanel toolBarPanel;
    private JButton selectAllBtn;
    private JButton selectNoneBtn;
    private JButton removeImagesBtn;
    private ImageGrid imageGrid;
    private JScrollPane gridScrollPane;
    private final int minColumns = 1;
    private final int maxColumns = 0;
    private boolean editMode;
    private ImagePanel editingNameItem;
    private boolean selectionIsAdjusting;
    private List<CyCustomGraphics> allImages;
    private CyCustomGraphics selectedImage;
    private ImagePanel overItem;
    private DebounceTimer resizeDebouncer = new DebounceTimer();
    private boolean ready;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public ImageCustomGraphicsSelector(CyServiceRegistrar serviceRegistrar) {
        this(false, serviceRegistrar);
    }

    public ImageCustomGraphicsSelector(CyCustomGraphics selectedImage, CyServiceRegistrar serviceRegistrar) {
        this(selectedImage, false, serviceRegistrar);
    }

    public ImageCustomGraphicsSelector(boolean editMode, CyServiceRegistrar serviceRegistrar) {
        this(null, editMode, serviceRegistrar);
    }

    public ImageCustomGraphicsSelector(CyCustomGraphics selectedImage, boolean editMode, CyServiceRegistrar serviceRegistrar) {
        super(true);
        this.serviceRegistrar = serviceRegistrar;
        this.allImages = new ArrayList<CyCustomGraphics>();
        this.BG_COLOR = UIManager.getColor("Table.background");
        this.FG_COLOR = UIManager.getColor("Table.foreground");
        this.SEL_BG_COLOR = UIManager.getColor("Table.focusCellBackground");
        this.SEL_FG_COLOR = UIManager.getColor("Table.focusCellForeground");
        this.FOCUS_BORDER_COLOR = UIManager.getColor("Table.selectionBackground");
        this.FOCUS_OVERLAY_COLOR = new Color(this.FOCUS_BORDER_COLOR.getRed(), this.FOCUS_BORDER_COLOR.getGreen(), this.FOCUS_BORDER_COLOR.getBlue(), 100);
        this.BORDER_COLOR = UIManager.getColor("Separator.foreground");
        this.init();
        this.setEditMode(editMode);
        if (editMode) {
            this.getEditBtn().setVisible(false);
        }
        this.update(((CustomGraphicsManager)serviceRegistrar.getService(CustomGraphicsManager.class)).getAllCustomGraphics(), selectedImage);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.ready = true;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        if (editMode != this.editMode) {
            this.selectionIsAdjusting = true;
            this.editMode = editMode;
            try {
                this.update();
                if (!editMode) {
                    this.getImageGrid().setSelectedValue(this.selectedImage, this.getImageGrid().isShowing());
                }
            }
            finally {
                this.selectionIsAdjusting = false;
            }
            this.firePropertyChange("editMode", !editMode, editMode);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getEditBtn().setEnabled(enabled);
        this.getSelectAllBtn().setEnabled(enabled);
        this.getSelectNoneBtn().setEnabled(enabled);
        this.getRemoveImagesBtn().setEnabled(enabled);
        this.getImageGrid().setEnabled(enabled);
    }

    public void update(Collection<CyCustomGraphics> images, CyCustomGraphics selectedValue) {
        this.allImages.clear();
        if (images != null) {
            for (CyCustomGraphics cg : images) {
                if (cg instanceof NullCustomGraphics) continue;
                this.allImages.add(cg);
            }
            this.allImages.sort(new CGComparator());
        }
        this.getImageGrid().update();
        this.update(selectedValue);
        this.update(true);
    }

    public void update(CyCustomGraphics selectedValue) {
        this.getImageGrid().setSelectedValue(selectedValue, this.getImageGrid().isShowing());
    }

    public void setSelectedImage(CyCustomGraphics image) {
        if (!Objects.equals(this.selectedImage, image)) {
            CyCustomGraphics oldValue = this.selectedImage;
            this.selectedImage = image;
            this.getImageGrid().setSelectedValue(image, this.getImageGrid().isShowing());
            if (!this.selectionIsAdjusting) {
                this.firePropertyChange("selectedImage", oldValue, this.selectedImage);
            }
        }
    }

    public CyCustomGraphics getSelectedImage() {
        return this.selectedImage;
    }

    public List<CyCustomGraphics> getSelectedImageList() {
        return this.getImageGrid().getSelectedValuesList();
    }

    public int getSelectionCount() {
        return this.getImageGrid().getSelectionModel().getSelectedItemsCount();
    }

    public boolean isSelected(CyCustomGraphics image) {
        int index = this.getImageGrid().indexOf(image);
        return this.getImageGrid().getSelectionModel().isSelectedIndex(index);
    }

    public boolean isEmpty() {
        return this.allImages == null || this.allImages.isEmpty();
    }

    public void loadNewImages() {
        Window owner = SwingUtilities.getWindowAncestor(this);
        LoadImageDialog dialog = new LoadImageDialog(owner, this.serviceRegistrar);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        List<AbstractURLImageCustomGraphics> images = dialog.getImages();
        this.addNewImages(images);
    }

    public void dispose() {
        try {
            this.allImages.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiersEx();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            try {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ActionListener.class) continue;
                    if (e == null) {
                        e = new ActionEvent(this, 1001, this.getActionCommand(), mostRecentEventTime, modifiers);
                    }
                    ((ActionListener)listeners[i + 1]).actionPerformed(e);
                }
            }
            finally {
                this.firingActionEvent = false;
            }
        }
    }

    private void init() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getEditBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getToolBarPanel(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.getGridScrollPane(), -1, -1, Short.MAX_VALUE).addComponent(this.getAddBtn(), -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getEditBtn()).addComponent(this.getToolBarPanel(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getGridScrollPane(), -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getAddBtn()).addContainerGap());
    }

    JScrollPane getGridScrollPane() {
        if (this.gridScrollPane == null) {
            this.gridScrollPane = new JScrollPane(this.getImageGrid());
            this.gridScrollPane.setPreferredSize(new Dimension(480, 300));
            this.gridScrollPane.setVerticalScrollBarPolicy(20);
            this.gridScrollPane.setHorizontalScrollBarPolicy(31);
            this.gridScrollPane.setBackground(this.BG_COLOR);
            this.gridScrollPane.getViewport().setBackground(this.BG_COLOR);
            this.gridScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    ImageCustomGraphicsSelector.this.resizeDebouncer.debounce(() -> ImageCustomGraphicsSelector.this.getImageGrid().update(false));
                }
            });
            MouseAdapter viewportMouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ImageCustomGraphicsSelector.this.isEditMode() && !evt.isShiftDown()) {
                        ImageCustomGraphicsSelector.this.getImageGrid().deselectAll();
                    }
                }
            };
            this.gridScrollPane.getViewport().addMouseListener(viewportMouseAdapter);
            this.gridScrollPane.getViewport().getView().addMouseListener(viewportMouseAdapter);
            this.gridScrollPane.setDropTarget(new URLDropTarget());
        }
        return this.gridScrollPane;
    }

    private ImageGrid getImageGrid() {
        if (this.imageGrid == null) {
            this.imageGrid = new ImageGrid(this.allImages);
            this.imageGrid.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        ImageCustomGraphicsSelector.this.fireActionEvent();
                    }
                }
            });
            this.imageGrid.getSelectionModel().addListSelectionListener(evt -> {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                this.update();
                this.selectedImage = this.getImageGrid().getSelectedValue();
            });
        }
        return this.imageGrid;
    }

    JButton getAddBtn() {
        if (this.addBtn == null) {
            Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(18.0f);
            TextIcon icon = new TextIcon("\uf067", iconFont, 18, 18);
            this.addBtn = new JButton("Add Images", (Icon)icon);
            this.addBtn.addActionListener(evt -> this.loadNewImages());
        }
        return this.addBtn;
    }

    JToggleButton getEditBtn() {
        if (this.editBtn == null) {
            Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(18.0f);
            TextIcon icon = new TextIcon("\uf044", iconFont, 18, 18);
            this.editBtn = new JToggleButton("Edit", (Icon)icon, this.isEditMode());
            this.editBtn.addActionListener(evt -> this.setEditMode(this.editBtn.isSelected()));
            if (LookAndFeelUtil.isAquaLAF()) {
                this.editBtn.putClientProperty("JButton.buttonType", "textured");
            }
        }
        return this.editBtn;
    }

    JPanel getToolBarPanel() {
        if (this.toolBarPanel == null) {
            this.toolBarPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.toolBarPanel);
            this.toolBarPanel.setLayout(layout);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getSelectAllBtn()).addComponent(this.getSelectNoneBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getRemoveImagesBtn()).addContainerGap());
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getSelectAllBtn(), -2, -1, -2).addComponent(this.getSelectNoneBtn(), -2, -1, -2).addComponent(this.getRemoveImagesBtn(), -2, -1, -2));
        }
        return this.toolBarPanel;
    }

    JButton getSelectAllBtn() {
        if (this.selectAllBtn == null) {
            this.selectAllBtn = this.createToolBarButton("\uf046\uf046", "Select All", 14.0f);
            this.selectAllBtn.addActionListener(evt -> this.getImageGrid().selectAll());
        }
        return this.selectAllBtn;
    }

    JButton getSelectNoneBtn() {
        if (this.selectNoneBtn == null) {
            this.selectNoneBtn = this.createToolBarButton("\uf096\uf096", "Select None", 14.0f);
            this.selectNoneBtn.addActionListener(evt -> this.getImageGrid().deselectAll());
        }
        return this.selectNoneBtn;
    }

    JButton getRemoveImagesBtn() {
        if (this.removeImagesBtn == null) {
            this.removeImagesBtn = this.createToolBarButton("\uf014", "Remove Selected Images", 18.0f);
            this.removeImagesBtn.addActionListener(evt -> this.removeSelectedImages());
        }
        return this.removeImagesBtn;
    }

    private void addNewImages(List<AbstractURLImageCustomGraphics> images) {
        CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        ArrayList<CyCustomGraphics> addedImages = new ArrayList<CyCustomGraphics>();
        for (AbstractURLImageCustomGraphics cg : images) {
            manager.addCustomGraphics(cg, cg.getSourceURL());
            addedImages.add(cg);
        }
        if (!addedImages.isEmpty()) {
            this.update(manager.getAllCustomGraphics(), null);
            if (this.isEditMode()) {
                this.getImageGrid().setSelectedList(addedImages);
            } else {
                this.getImageGrid().setSelectedValue(addedImages.get(0), false);
            }
            this.getImageGrid().ensureIndexIsVisible(this.getImageGrid().getMinSelectionIndex());
        }
    }

    private void removeSelectedImages() {
        List<CyCustomGraphics> selectedValues = this.imageGrid.getSelectedValuesList();
        if (!selectedValues.isEmpty()) {
            CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
            ArrayList<CyCustomGraphics> toBeRemoved = new ArrayList<CyCustomGraphics>();
            ArrayList<CyCustomGraphics> inUse = new ArrayList<CyCustomGraphics>();
            for (CyCustomGraphics cg : selectedValues) {
                if (manager.isUsedInCurrentSession(cg)) {
                    inUse.add(cg);
                    continue;
                }
                toBeRemoved.add(cg);
            }
            for (CyCustomGraphics cg : toBeRemoved) {
                manager.removeCustomGraphics(cg.getIdentifier());
            }
            if (!toBeRemoved.isEmpty()) {
                this.update(manager.getAllCustomGraphics(), null);
            }
            if (!inUse.isEmpty()) {
                String msg = inUse.size() == 1 ? "<html><pre>" + CustomGraphicsUtil.getShortName(((CyCustomGraphics)inUse.get(0)).getDisplayName()) + "</pre>is being used in the current session and cannot be removed.</html>" : (Serializable)(inUse.size() == selectedValues.size() ? "The" : Integer.valueOf(inUse.size())) + " images are being used in the current session and cannot be removed.";
                JOptionPane.showMessageDialog(this, msg, "Custom Graphics in Use", 0);
            }
        }
    }

    private int calculateColumns(int itemWidth, int gridWidth) {
        int cols = itemWidth > 0 ? Math.floorDiv(gridWidth, itemWidth) : 1;
        cols = Math.max(cols, 1);
        return Math.max(cols, 0);
    }

    private int calculateRows(int total, int cols) {
        return (int)Math.round(Math.ceil((float)total / (float)cols));
    }

    private JButton createToolBarButton(String iconText, String tooltipText, float size) {
        JButton btn = new JButton(iconText);
        btn.setToolTipText(tooltipText);
        ViewUtil.styleToolBarButton(btn, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(size), 2, 0);
        return btn;
    }

    public void setDirty(CyCustomGraphics image) {
        this.getImageGrid().setDirty(image);
    }

    void update() {
        this.update(false);
    }

    void update(boolean updateThumbnails) {
        this.setEnabled(!this.isEmpty());
        this.getEditBtn().setSelected(this.isEditMode());
        this.getToolBarPanel().setVisible(this.isEditMode());
        if (updateThumbnails) {
            this.getImageGrid().updateImagePanels();
        }
        this.getImageGrid().getSelectionModel().setSelectionMode(this.isEditMode() ? 2 : 0);
        this.updateToolBarButtons();
    }

    private void updateToolBarButtons() {
        if (this.isEnabled() && this.isEditMode()) {
            List<CyCustomGraphics> selValues = this.getImageGrid().getSelectedValuesList();
            int selCount = selValues.size();
            int total = this.getImageGrid().getModel().getSize();
            this.getSelectAllBtn().setEnabled(selCount < total);
            this.getSelectNoneBtn().setEnabled(selCount > 0);
            this.getRemoveImagesBtn().setEnabled(selCount > 1 || selCount == 1);
        }
    }

    class ImageGrid
    extends JComponent
    implements Scrollable {
        private final LinkedHashMap<CyCustomGraphics, ImagePanel> vsPanelMap = new LinkedHashMap();
        private final JPanel filler = new JPanel();
        private final JLabel dropIconLabel = new JLabel();
        private final JLabel dropLabel = new JLabel("Drag image files here");
        private ListModel<CyCustomGraphics> dataModel;
        private DefaultListSelectionModel selectionModel;
        private int cols;
        private int rows;
        private int cellWidth;
        private int cellHeight;
        private boolean autoScroll = true;

        ImageGrid(Collection<CyCustomGraphics> data) {
            this.dataModel = new ImageGridModel(data);
            this.selectionModel = new DefaultListSelectionModel();
            this.selectionModel.addListSelectionListener(e -> this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting()));
            this.setOpaque(true);
            this.setBackground(ImageCustomGraphicsSelector.this.BG_COLOR);
            Color fg = UIManager.getColor("Label.disabledForeground");
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 120);
            this.dropIconLabel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("/images/drop-img-file-56.png")));
            this.dropIconLabel.setForeground(fg);
            this.dropLabel.setFont(this.dropLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.dropLabel.setForeground(fg);
            this.filler.setAlignmentX(0.0f);
            this.filler.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.filler.setBackground(this.getBackground());
            this.filler.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createDashedBorder(fg, 2.0f, 2.0f, 2.0f, true)));
            this.filler.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        ImageGrid.this.deselectAll();
                    }
                }
            });
            GroupLayout layout = new GroupLayout(this.filler);
            this.filler.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            this.setKeyBindings();
            this.selectionModel.addListSelectionListener(evt -> {
                this.revalidate();
                this.repaint();
            });
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getModel().getSize() == 0 ? this.getMinimumSize() : this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getModel().getSize() == 0;
        }

        @Override
        public void repaint() {
            for (ImagePanel item : this.vsPanelMap.values()) {
                item.repaint();
            }
            super.repaint();
        }

        ImagePanel getItem(CyCustomGraphics image) {
            return this.vsPanelMap.get(image);
        }

        ImagePanel getItem(int index) {
            ListModel<CyCustomGraphics> dm = this.getModel();
            CyCustomGraphics cg = dm.getElementAt(index);
            return this.getItem(cg);
        }

        int indexOf(CyCustomGraphics image) {
            ListModel<CyCustomGraphics> dm = this.getModel();
            int total = dm.getSize();
            int c = total;
            for (int i = 0; i < c; ++i) {
                if (!image.equals(dm.getElementAt(i))) continue;
                return i;
            }
            return -1;
        }

        void setFocus(int index) {
            ImagePanel item;
            ListModel<CyCustomGraphics> dm = this.getModel();
            if (index > -1 && index < dm.getSize() && (item = this.getItem(index)) != null) {
                item.requestFocusInWindow();
            }
        }

        CyCustomGraphics getSelectedValue() {
            int i = this.getMinSelectionIndex();
            return i == -1 || i >= this.getModel().getSize() ? null : this.getModel().getElementAt(i);
        }

        void setSelectedValue(CyCustomGraphics image, boolean shouldScroll) {
            if (image == null) {
                this.deselectAll();
            } else if (!image.equals(this.getSelectedValue())) {
                int i = this.indexOf(image);
                this.setSelectedIndex(i);
                if (i >= 0 && shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
            }
        }

        List<CyCustomGraphics> getSelectedValuesList() {
            int total;
            ListModel<CyCustomGraphics> dm = this.getModel();
            ListSelectionModel sm = this.getSelectionModel();
            int[] selectedIndices = sm.getSelectedIndices();
            ArrayList<CyCustomGraphics> selectedItems = new ArrayList<CyCustomGraphics>();
            if (selectedIndices.length > 0 && selectedIndices[0] < (total = dm.getSize())) {
                for (int i : selectedIndices) {
                    if (i >= total) break;
                    selectedItems.add(dm.getElementAt(i));
                }
            }
            return selectedItems;
        }

        void selectAll() {
            if (this.getModel().getSize() >= 0) {
                this.selectionModel.setSelectionInterval(0, this.getModel().getSize() - 1);
            }
        }

        void deselectAll() {
            this.selectionModel.clearSelection();
            this.selectionModel.setAnchorSelectionIndex(-1);
            this.selectionModel.setLeadSelectionIndex(-1);
        }

        void setSelectedIndex(int index) {
            if (index >= this.getModel().getSize()) {
                return;
            }
            this.selectionModel.setSelectionInterval(index, index);
        }

        int getMinSelectionIndex() {
            return this.selectionModel.getMinSelectionIndex();
        }

        int getMaxSelectionIndex() {
            return this.selectionModel.getMaxSelectionIndex();
        }

        boolean isSelectedIndex(int index) {
            return this.selectionModel.isSelectedIndex(index);
        }

        boolean isSelectionEmpty() {
            return this.selectionModel.isSelectionEmpty();
        }

        ListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        void setSelectionInterval(int anchor, int lead) {
            this.selectionModel.setSelectionInterval(anchor, lead);
        }

        void addSelectionInterval(int anchor, int lead) {
            this.selectionModel.addSelectionInterval(anchor, lead);
        }

        void removeSelectionInterval(int index0, int index1) {
            this.selectionModel.removeSelectionInterval(index0, index1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSelectedList(List<CyCustomGraphics> images) {
            this.selectionModel.setValueIsAdjusting(true);
            try {
                this.selectionModel.clearSelection();
                int maxIdx = -1;
                for (CyCustomGraphics cg : images) {
                    int idx = this.indexOf(cg);
                    if (idx < 0) continue;
                    this.selectionModel.addSelectionInterval(idx, idx);
                    maxIdx = Math.max(idx, maxIdx);
                }
                this.selectionModel.setAnchorSelectionIndex(maxIdx);
                this.selectionModel.setLeadSelectionIndex(maxIdx);
            }
            finally {
                this.selectionModel.setValueIsAdjusting(false);
            }
        }

        ListModel<CyCustomGraphics> getModel() {
            return this.dataModel;
        }

        void setModel(ListModel<CyCustomGraphics> model) {
            if (model == null) {
                throw new IllegalArgumentException("model must be non null");
            }
            ListModel<CyCustomGraphics> oldValue = this.dataModel;
            this.dataModel = model;
            this.firePropertyChange("model", oldValue, this.dataModel);
            ImageCustomGraphicsSelector.this.selectionIsAdjusting = true;
            try {
                this.deselectAll();
                this.update(true);
            }
            finally {
                ImageCustomGraphicsSelector.this.selectionIsAdjusting = false;
            }
        }

        void ensureIndexIsVisible(int index) {
            Rectangle cellBounds = this.getCellBounds(index, index);
            if (cellBounds != null) {
                this.scrollRectToVisible(cellBounds);
            }
        }

        Rectangle getCellBounds(int index1, int index2) {
            int minIndex = Math.min(index1, index2);
            int maxIndex = Math.max(index1, index2);
            if (minIndex >= this.getModel().getSize()) {
                return null;
            }
            Rectangle minBounds = this.getCellBounds(minIndex);
            if (minBounds == null) {
                return null;
            }
            if (minIndex == maxIndex) {
                return minBounds;
            }
            Rectangle maxBounds = this.getCellBounds(maxIndex);
            if (maxBounds != null) {
                int maxRow;
                int minRow = this.convertModelToRow(minIndex);
                if (minRow != (maxRow = this.convertModelToRow(maxIndex))) {
                    minBounds.x = 0;
                    minBounds.width = this.getWidth();
                }
                minBounds.add(maxBounds);
            }
            return minBounds;
        }

        private Rectangle getCellBounds(int index) {
            int row = this.convertModelToRow(index);
            int column = this.convertModelToColumn(index);
            if (row == -1 || column == -1) {
                return null;
            }
            Insets insets = this.getInsets();
            int x = insets.left + column * this.cellWidth;
            int w = this.cellWidth;
            int y = insets.top + this.cellHeight * row;
            int h = this.cellHeight;
            return new Rectangle(x, y, w, h);
        }

        private int convertModelToRow(int index) {
            int size = this.getModel().getSize();
            if (index < 0 || index >= size) {
                return -1;
            }
            if (this.cols > 1 && this.rows > 0) {
                return index / this.cols;
            }
            return index;
        }

        private int convertModelToColumn(int index) {
            int size = this.getModel().getSize();
            if (index < 0 || index >= size) {
                return -1;
            }
            if (this.rows > 0 && this.cols > 1) {
                return index % this.cols;
            }
            return 0;
        }

        protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        void setDirty(CyCustomGraphics image) {
            ImagePanel item;
            if (image != null && (item = this.getItem(image)) != null) {
                item.setDirty();
            }
        }

        void updateImagePanels() {
            for (ImagePanel item : this.vsPanelMap.values()) {
                if (!item.isDirty()) continue;
                item.update();
            }
        }

        void update(boolean recreateItems) {
            ListModel<CyCustomGraphics> dm = this.getModel();
            int total = dm.getSize();
            if (total > 0) {
                int gridWidth;
                this.removeAll();
                if (recreateItems) {
                    this.vsPanelMap.clear();
                    for (int i = 0; i < total; ++i) {
                        CyCustomGraphics cg = dm.getElementAt(i);
                        ImagePanel itemPnl = this.getItem(cg);
                        if (itemPnl == null) {
                            itemPnl = this.createItem(cg);
                        }
                        this.vsPanelMap.put(cg, itemPnl);
                    }
                }
                if ((gridWidth = this.getWidth()) > 0) {
                    int itemWidth = 130;
                    this.cols = Math.max(1, ImageCustomGraphicsSelector.this.calculateColumns(itemWidth, gridWidth));
                } else {
                    this.cols = 1;
                }
                this.rows = ImageCustomGraphicsSelector.this.calculateRows(total, this.cols);
                if (!ImageCustomGraphicsSelector.this.ready) {
                    return;
                }
                this.setLayout(new GridLayout(this.rows, this.cols));
                for (ImagePanel itemPnl : this.vsPanelMap.values()) {
                    this.add(itemPnl);
                }
                this.revalidate();
                this.cellWidth = this.getWidth() / this.cols;
                this.cellHeight = this.getHeight() / this.rows;
                if (this.autoScroll && this.cellWidth > 0 && this.cellHeight > 0 && this.getMinSelectionIndex() >= 0) {
                    this.ensureIndexIsVisible(this.getMinSelectionIndex());
                    this.repaint();
                    this.autoScroll = false;
                }
            } else if (this.getComponentCount() == 0 || this.getComponent(0) != this.filler) {
                this.removeAll();
                this.setLayout(new BoxLayout(this, 1));
                this.add(this.filler);
                this.revalidate();
                this.cellWidth = 0;
                this.cellHeight = 0;
            }
        }

        void update() {
            List<Object> selectedImages;
            List<Object> list = selectedImages = ImageCustomGraphicsSelector.this.isEditMode() ? ImageCustomGraphicsSelector.this.getSelectedImageList() : new ArrayList();
            if (ImageCustomGraphicsSelector.this.selectedImage != null && !ImageCustomGraphicsSelector.this.isEditMode()) {
                selectedImages.add(ImageCustomGraphicsSelector.this.selectedImage);
            }
            ImageCustomGraphicsSelector.this.selectionIsAdjusting = true;
            try {
                this.setModel(new ImageGridModel(ImageCustomGraphicsSelector.this.allImages));
                this.setSelectedList(selectedImages);
            }
            finally {
                ImageCustomGraphicsSelector.this.selectionIsAdjusting = false;
            }
        }

        private ImagePanel createItem(CyCustomGraphics image) {
            final ImagePanel item = new ImagePanel(image);
            item.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ImageGrid.this.isEnabled()) {
                        ImageCustomGraphicsSelector.this.overItem = item;
                        ImageGrid.this.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ImageGrid.this.isEnabled()) {
                        ImageCustomGraphicsSelector.this.overItem = null;
                        ImageGrid.this.repaint();
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ImageGrid.this.isEnabled()) {
                        if (!ImageCustomGraphicsSelector.this.isEditMode() && !evt.isPopupTrigger() && evt.getClickCount() == 2) {
                            ImageGrid.this.setSelectedValue(item.getImage(), false);
                            ImageCustomGraphicsSelector.this.fireActionEvent();
                        } else {
                            ImageGrid.this.onMousePressedItem(evt, item);
                        }
                    }
                }
            });
            item.getNameTextField().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ImageGrid.this.isEnabled()) {
                        ImageGrid.this.onMousePressedItem(evt, item);
                        evt.consume();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (ImageGrid.this.isEnabled()) {
                        if (ImageCustomGraphicsSelector.this.isEditMode() && evt.getClickCount() == 2) {
                            ImageGrid.this.editNameStart(item);
                        }
                        evt.consume();
                    }
                }
            });
            return item;
        }

        private void onMousePressedItem(MouseEvent evt, ImagePanel item) {
            if (ImageCustomGraphicsSelector.this.isEditMode() && ImageCustomGraphicsSelector.this.editingNameItem != null) {
                if (item.equals(ImageCustomGraphicsSelector.this.editingNameItem)) {
                    return;
                }
                this.editNameCommit(ImageCustomGraphicsSelector.this.editingNameItem, null);
            }
            item.requestFocusInWindow();
            if (ImageCustomGraphicsSelector.this.isEditMode()) {
                int index = this.indexOf(item.image);
                if (!evt.isPopupTrigger() && SwingUtilities.isLeftMouseButton(evt)) {
                    boolean isMac = LookAndFeelUtil.isMac();
                    if (isMac && evt.isMetaDown() || !isMac && evt.isControlDown()) {
                        this.toggleSelection(item);
                    } else if (evt.isShiftDown()) {
                        this.shiftSelectTo(index);
                    } else {
                        this.setSelectedValue(item.getImage(), false);
                    }
                }
            } else {
                this.setSelectedValue(item.getImage(), false);
            }
            item.repaint();
            if (evt.isPopupTrigger()) {
                this.showContextMenu(evt, item);
            }
        }

        private void shiftSelectTo(int index) {
            int size = this.getModel().getSize();
            if (index < 0 || index >= size) {
                return;
            }
            int anchor = this.selectionModel.getAnchorSelectionIndex();
            int lead = this.selectionModel.getLeadSelectionIndex();
            this.selectionModel.setValueIsAdjusting(true);
            if (anchor != lead && (anchor >= 0 || lead >= 0)) {
                this.selectionModel.removeSelectionInterval(Math.max(0, anchor), Math.max(0, lead));
            }
            this.selectionModel.addSelectionInterval(Math.max(0, anchor), index);
            this.selectionModel.setValueIsAdjusting(false);
            this.getItem(index).requestFocusInWindow();
        }

        private void showContextMenu(MouseEvent me, ImagePanel item) {
            JPopupMenu popup = new JPopupMenu();
            IconManager iconManager = (IconManager)ImageCustomGraphicsSelector.this.serviceRegistrar.getService(IconManager.class);
            Font iconFont = iconManager.getIconFont(18.0f);
            TextIcon icon = new TextIcon("\uf014", iconFont, 18, 18);
            JMenuItem mi = new JMenuItem("Remove " + (ImageCustomGraphicsSelector.this.isEditMode() ? "Selected Images" : "Image"), (Icon)icon);
            mi.addActionListener(evt -> ImageCustomGraphicsSelector.this.removeSelectedImages());
            mi.setEnabled(!ImageCustomGraphicsSelector.this.getImageGrid().getSelectionModel().isSelectionEmpty());
            popup.add(mi);
            popup.show(item, me.getX(), me.getY());
        }

        private void toggleSelection(ImagePanel item) {
            int index = this.indexOf(item.image);
            if (this.isSelectedIndex(index)) {
                this.removeSelectionInterval(index, index);
            } else {
                this.addSelectionInterval(index, index);
            }
            this.selectionModel.setValueIsAdjusting(true);
            if (this.selectionModel.isSelectedIndex(index)) {
                this.selectionModel.setAnchorSelectionIndex(index);
                this.selectionModel.moveLeadSelectionIndex(index);
            } else {
                index = this.selectionModel.getMaxSelectionIndex();
                this.selectionModel.setAnchorSelectionIndex(index);
                this.selectionModel.moveLeadSelectionIndex(index);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }

        void editNameStart(final ImagePanel item) {
            ImageCustomGraphicsSelector.this.editingNameItem = item;
            final String oldValue = item.getNameTextField().getText().trim();
            item.getNameTextField().setFocusable(true);
            item.getNameTextField().setEditable(true);
            item.getNameTextField().requestFocusInWindow();
            item.getNameTextField().selectAll();
            item.getNameTextField().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageGrid.this.editNameCommit(item, oldValue);
                    item.getNameTextField().removeActionListener(this);
                }
            });
            item.getNameTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    ImageGrid.this.editNameCommit(item, oldValue);
                    item.getNameTextField().removeFocusListener(this);
                }
            });
            item.getNameTextField().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 27) {
                        ImageGrid.this.editNameCancel(item, oldValue);
                        item.getNameTextField().removeKeyListener(this);
                        evt.consume();
                    }
                }
            });
        }

        void editNameCommit(ImagePanel item, String oldValue) {
            String newValue = item.getNameTextField().getText().trim();
            if (newValue.isEmpty() || newValue.equals(oldValue)) {
                this.editNameCancel(item, oldValue);
                return;
            }
            this.editNameEnd(item);
            item.getImage().setDisplayName(newValue);
        }

        void editNameCancel(ImagePanel item, String oldValue) {
            item.getNameTextField().setText(oldValue);
            this.editNameEnd(item);
        }

        void editNameEnd(ImagePanel item) {
            item.getNameTextField().setEditable(false);
            item.requestFocusInWindow();
            item.getNameTextField().setFocusable(false);
            ImageCustomGraphicsSelector.this.editingNameItem = null;
        }

        private void setKeyBindings() {
            ActionMap actionMap = this.getActionMap();
            InputMap inputMap = this.getInputMap(1);
            int ctrl = LookAndFeelUtil.isMac() ? 256 : 128;
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
            inputMap.put(KeyStroke.getKeyStroke(37, 64), "VK_SHIFT_LEFT");
            inputMap.put(KeyStroke.getKeyStroke(39, 64), "VK_SHIFT_RIGHT");
            inputMap.put(KeyStroke.getKeyStroke(38, 64), "VK_SHIFT_UP");
            inputMap.put(KeyStroke.getKeyStroke(40, 64), "VK_SHIFT_DOWN");
            inputMap.put(KeyStroke.getKeyStroke(65, ctrl), "VK_CTRL_A");
            inputMap.put(KeyStroke.getKeyStroke(65, ctrl + 64), "VK_CTRL_SHIFT_A");
            actionMap.put("VK_LEFT", new KeyAction("VK_LEFT"));
            actionMap.put("VK_RIGHT", new KeyAction("VK_RIGHT"));
            actionMap.put("VK_UP", new KeyAction("VK_UP"));
            actionMap.put("VK_DOWN", new KeyAction("VK_DOWN"));
            actionMap.put("VK_SHIFT_LEFT", new KeyAction("VK_SHIFT_LEFT"));
            actionMap.put("VK_SHIFT_RIGHT", new KeyAction("VK_SHIFT_RIGHT"));
            actionMap.put("VK_SHIFT_UP", new KeyAction("VK_SHIFT_UP"));
            actionMap.put("VK_SHIFT_DOWN", new KeyAction("VK_SHIFT_DOWN"));
            actionMap.put("VK_CTRL_A", new KeyAction("VK_CTRL_A"));
            actionMap.put("VK_CTRL_SHIFT_A", new KeyAction("VK_CTRL_SHIFT_A"));
        }

        private class KeyAction
        extends AbstractAction {
            static final String VK_LEFT = "VK_LEFT";
            static final String VK_RIGHT = "VK_RIGHT";
            static final String VK_UP = "VK_UP";
            static final String VK_DOWN = "VK_DOWN";
            static final String VK_SHIFT_LEFT = "VK_SHIFT_LEFT";
            static final String VK_SHIFT_RIGHT = "VK_SHIFT_RIGHT";
            static final String VK_SHIFT_UP = "VK_SHIFT_UP";
            static final String VK_SHIFT_DOWN = "VK_SHIFT_DOWN";
            static final String VK_CTRL_A = "VK_CTRL_A";
            static final String VK_CTRL_SHIFT_A = "VK_CTRL_SHIFT_A";

            KeyAction(String actionCommand) {
                this.putValue("ActionCommandKey", actionCommand);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListModel<CyCustomGraphics> dm = ImageGrid.this.getModel();
                if (dm.getSize() > 0) {
                    int idx;
                    String cmd = evt.getActionCommand();
                    int size = dm.getSize();
                    ListSelectionModel sm = ImageGrid.this.getSelectionModel();
                    int newIdx = idx = sm.getLeadSelectionIndex();
                    boolean shift = cmd.startsWith("VK_SHIFT_");
                    if (cmd.equals(VK_RIGHT) || cmd.equals(VK_SHIFT_RIGHT)) {
                        newIdx = idx + 1;
                    } else if (cmd.equals(VK_LEFT) || cmd.equals(VK_SHIFT_LEFT)) {
                        newIdx = idx - 1;
                    } else if (cmd.equals(VK_UP) || cmd.equals(VK_SHIFT_UP)) {
                        newIdx = idx - ImageGrid.this.cols < 0 ? idx : idx - ImageGrid.this.cols;
                    } else if (cmd.equals(VK_DOWN) || cmd.equals(VK_SHIFT_DOWN)) {
                        boolean sameRow = Math.ceil((double)size / (double)ImageGrid.this.cols) == Math.ceil((double)(idx + 1) / (double)ImageGrid.this.cols);
                        newIdx = sameRow ? idx : Math.min(size - 1, idx + ImageGrid.this.cols);
                    } else if (cmd.equals(VK_CTRL_A)) {
                        if (ImageCustomGraphicsSelector.this.isEditMode()) {
                            ImageGrid.this.selectAll();
                        }
                    } else if (cmd.equals(VK_CTRL_SHIFT_A) && ImageCustomGraphicsSelector.this.isEditMode()) {
                        ImageGrid.this.deselectAll();
                    }
                    if (newIdx != idx) {
                        if (shift) {
                            ImageGrid.this.shiftSelectTo(newIdx);
                        } else {
                            ImageGrid.this.setSelectedIndex(newIdx);
                        }
                    }
                }
            }
        }

        private class ListSelectionHandler
        implements ListSelectionListener,
        Serializable {
            private ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImageGrid.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
            }
        }
    }

    private class URLDropTarget
    extends DropTarget {
        private Border originalBorder;
        private final Border dropBorder = BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 2);
        private DataFlavor urlFlavor;

        URLDropTarget() {
            try {
                this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(3);
                Transferable trans = dtde.getTransferable();
                boolean gotData = false;
                try {
                    if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List fileList = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                        File[] files = fileList.toArray(new File[fileList.size()]);
                        CustomGraphicsManager manager = (CustomGraphicsManager)ImageCustomGraphicsSelector.this.serviceRegistrar.getService(CustomGraphicsManager.class);
                        List<AbstractURLImageCustomGraphics> loadedImages = ImageUtil.loadImageCustomGraphics(files, manager);
                        ImageCustomGraphicsSelector.this.addNewImages(loadedImages);
                    } else {
                        AbstractURLImageCustomGraphics<?> lastCG = null;
                        if (trans.isDataFlavorSupported(this.urlFlavor)) {
                            URL url = (URL)trans.getTransferData(this.urlFlavor);
                            lastCG = this.addCustomGraphics(url.toString());
                            gotData = true;
                        } else if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String s = (String)trans.getTransferData(DataFlavor.stringFlavor);
                            URL url = new URL(s);
                            lastCG = this.addCustomGraphics(url.toString());
                            gotData = true;
                        }
                        if (lastCG != null) {
                            CustomGraphicsManager manager = (CustomGraphicsManager)ImageCustomGraphicsSelector.this.serviceRegistrar.getService(CustomGraphicsManager.class);
                            ImageCustomGraphicsSelector.this.update(manager.getAllCustomGraphics(), lastCG);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    dtde.dropComplete(gotData);
                }
            }
            catch (Exception e) {
                logger.error("Error drag-and-dropping image(s): ", (Throwable)e);
            }
            finally {
                this.resetBorder();
            }
        }

        @Override
        public synchronized void dragEnter(DropTargetDragEvent dtde) {
            super.dragEnter(dtde);
            Component c = this.getComponent();
            if (c instanceof JComponent) {
                try {
                    this.originalBorder = ((JComponent)c).getBorder();
                    ((JComponent)c).setBorder(this.dropBorder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public synchronized void dragExit(DropTargetEvent dte) {
            super.dragExit(dte);
            this.resetBorder();
        }

        private void resetBorder() {
            Component c = this.getComponent();
            if (c instanceof JComponent) {
                try {
                    ((JComponent)c).setBorder(this.originalBorder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private AbstractURLImageCustomGraphics<?> addCustomGraphics(String urlStr) {
            CustomGraphicsManager manager = (CustomGraphicsManager)ImageCustomGraphicsSelector.this.serviceRegistrar.getService(CustomGraphicsManager.class);
            try {
                AbstractURLImageCustomGraphics cg;
                URL url = new URL(urlStr);
                Long id = manager.getNextAvailableID();
                AbstractURLImageCustomGraphics abstractURLImageCustomGraphics = cg = CustomGraphicsUtil.isSVG(url) ? new SVGCustomGraphics(id, url) : new BitmapCustomGraphics(id, url);
                if (cg != null) {
                    manager.addCustomGraphics(cg, url);
                }
                return cg;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    class ImagePanel
    extends JComponent {
        private JLabel imageLabel;
        private JTextField nameTextField;
        private final CyCustomGraphics image;
        private boolean dirty = true;

        ImagePanel(CyCustomGraphics image) {
            this.image = image;
            this.init();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (ImagePanel.this.isEnabled() && ImageCustomGraphicsSelector.this.editingNameItem == null) {
                        ImagePanel.this.requestFocusInWindow();
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ImagePanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ImagePanel.this.repaint();
                }
            });
        }

        CyCustomGraphics getImage() {
            return this.image;
        }

        private void init() {
            this.setBackground(ImageCustomGraphicsSelector.this.BG_COLOR);
            this.setFocusable(true);
            this.setDoubleBuffered(true);
            int gap = 4;
            this.setBorder(BorderFactory.createEmptyBorder(gap, gap, gap, gap));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateGaps(false);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getImageLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getNameTextField(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getImageLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getNameTextField(), -2, -1, -2));
        }

        JLabel getImageLabel() {
            if (this.imageLabel == null) {
                this.imageLabel = new JLabel();
                this.imageLabel.setHorizontalAlignment(0);
                this.imageLabel.setOpaque(true);
                int bw = 1;
                this.imageLabel.setBorder(BorderFactory.createMatteBorder(0, 0, bw, 0, ImageCustomGraphicsSelector.this.BORDER_COLOR));
                this.imageLabel.setMinimumSize(new Dimension(120, 68 + bw));
            }
            return this.imageLabel;
        }

        JTextField getNameTextField() {
            if (this.nameTextField == null) {
                String text = CustomGraphicsUtil.getShortName(this.image.getDisplayName());
                this.nameTextField = new JTextField(text){

                    @Override
                    public String getToolTipText(MouseEvent evt) {
                        return "<html><p image='text-align: center;'><b>" + CustomGraphicsUtil.getShortName(ImagePanel.this.image.getDisplayName()) + "</b>" + (ImageCustomGraphicsSelector.this.isEditMode() ? "<br>(double-click to rename...)" : "") + "</p></html>";
                    }
                };
                this.nameTextField.setHorizontalAlignment(0);
                this.nameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.nameTextField.setBackground(ImageCustomGraphicsSelector.this.BG_COLOR);
                this.nameTextField.setEditable(false);
                this.nameTextField.setFocusable(false);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.nameTextField});
            }
            return this.nameTextField;
        }

        boolean isDirty() {
            return this.dirty;
        }

        void setDirty() {
            this.dirty = true;
        }

        void update() {
            Icon icon = VisualPropertyIconFactory.createIcon(this.image, 120, 68);
            this.getImageLabel().setIcon(icon);
            this.getNameTextField().setText(CustomGraphicsUtil.getShortName(this.image.getDisplayName()));
            this.getNameTextField().setToolTipText(this.image.getDisplayName());
            this.dirty = false;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            int arc = 10;
            if (ImageCustomGraphicsSelector.this.isSelected(this.image)) {
                g2d.setColor(ImageCustomGraphicsSelector.this.SEL_BG_COLOR);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            } else {
                g2d.setColor(ImageCustomGraphicsSelector.this.BORDER_COLOR);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            }
            if (ImageCustomGraphicsSelector.this.overItem == this) {
                g2d.setColor(ImageCustomGraphicsSelector.this.FOCUS_OVERLAY_COLOR);
                g2d.fillRect(2, 2, w - 4, h - 4);
                g2d.setColor(ImageCustomGraphicsSelector.this.FOCUS_BORDER_COLOR);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(2, 2, w - 4, h - 4, arc, arc);
            }
            g2d.dispose();
        }

        @Override
        public String toString() {
            return this.image.getDisplayName();
        }
    }

    class ImageGridModel
    extends AbstractListModel<CyCustomGraphics> {
        private final List<CyCustomGraphics> data = new ArrayList<CyCustomGraphics>();

        public ImageGridModel(Collection<CyCustomGraphics> data) {
            this.data.addAll(data);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public CyCustomGraphics getElementAt(int index) {
            return this.data.get(index);
        }
    }
}

