/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public final class CustomGraphicsUtil {
    public static boolean isSVG(URL url) throws IOException {
        String protocol;
        URLConnection conn = url.openConnection();
        String type = conn.getHeaderField("Content-Type");
        if ("image/svg+xml".equalsIgnoreCase(type)) {
            return true;
        }
        if (type == null && (protocol = url.getProtocol()).equalsIgnoreCase("file")) {
            return url.getFile().toLowerCase().endsWith(".svg");
        }
        return false;
    }

    public static String getShortName(URL url) {
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
            return url.getAuthority() + url.getFile();
        }
        if (url.getProtocol().equals("file")) {
            return CustomGraphicsUtil.getShortName(url.getPath());
        }
        return url.toString();
    }

    public static String getShortName(String pathName) {
        if (pathName == null) {
            return null;
        }
        return new File(pathName).getName();
    }

    public static Image getResizedImage(Image original, Integer w, Integer h, boolean keepAspectRatio) {
        if (original == null) {
            throw new IllegalArgumentException("Original image cannot be null.");
        }
        if (w == null && h == null) {
            return original;
        }
        int currentW = original.getWidth(null);
        int currentH = original.getHeight(null);
        if (!keepAspectRatio) {
            return original.getScaledInstance(w, h, 16);
        }
        if (h == null) {
            float ratio = (float)currentH / (float)currentW;
            int converted = (int)((float)w.intValue() * ratio);
            return original.getScaledInstance(w, converted, 16);
        }
        float ratio = (float)currentW / (float)currentH;
        int converted = (int)((float)h.intValue() * ratio);
        return original.getScaledInstance(converted, h, 16);
    }

    private CustomGraphicsUtil() {
    }
}

