/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;

public class SVGCustomGraphics
extends AbstractURLImageCustomGraphics<SVGLayer> {
    public static final String TYPE_NAMESPACE = "org.cytoscape.ding.customgraphics.image";
    public static final String TYPE_NAME = "SVGCustomGraphics";
    private static final String DEF_TAG = "vector image";
    private static final String DEF_IMAGE_FILE = "/images/no_image.svg";
    private String svg;
    private final SVGLayer svgLayer;
    private SVGLayer renderedImageLayer;
    public static String DEF_IMAGE;

    public SVGCustomGraphics(Long id, URL url) throws IOException {
        super(id, url);
        this.svgLayer = this.createLayer();
        this.init();
    }

    public SVGCustomGraphics(Long id, String name, URL url) throws IOException {
        super(id, name, url);
        this.svgLayer = this.createLayer();
        this.init();
    }

    public SVGCustomGraphics(Long id, String name, String svg) throws IOException {
        super(id, name);
        if (svg == null || svg.isBlank()) {
            throw new IllegalArgumentException("'svg' must not be null or empty");
        }
        this.svg = svg;
        this.svgLayer = this.createLayer();
        this.init();
    }

    public SVGCustomGraphics(Long id, URL url, String svg) throws IOException {
        this(id, CustomGraphicsUtil.getShortName(url), svg);
        this.sourceUrl = url;
    }

    public SVGCustomGraphics(Long id, String name, URL url, String svg) throws IOException {
        this(id, name, svg);
        this.sourceUrl = url;
    }

    @Override
    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public List<SVGLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> graphObject) {
        return this.getLayers();
    }

    @Override
    public List<SVGLayer> getLayers(CyTableView tableView, CyColumnView columnView, CyRow row) {
        return this.getLayers();
    }

    public List<SVGLayer> getLayers() {
        if (this.layers.isEmpty()) {
            this.layers.add(this.svgLayer);
        }
        return this.layers;
    }

    @Override
    public Image getRenderedImage() {
        if (this.renderedImageLayer == null) {
            this.renderedImageLayer = this.createLayer();
        }
        return this.renderedImageLayer.createImage(new Rectangle(this.width, this.height));
    }

    public String getSVG() {
        return this.svg;
    }

    private void init() {
        this.tags.add(DEF_TAG);
        Rectangle bounds = this.svgLayer.getBounds2D().getBounds();
        this.width = bounds.width;
        this.height = bounds.height;
    }

    private SVGLayer createLayer() {
        if (this.svg == null) {
            try {
                URL sourceUrl = this.getSourceURL();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(sourceUrl.openStream()));){
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    this.svg = sb.toString();
                }
                catch (Exception e) {
                    this.svg = DEF_IMAGE;
                }
            }
            catch (Exception e) {
                this.svg = DEF_IMAGE;
            }
            if (this.svg == null) {
                this.svg = DEF_IMAGE;
            }
        }
        SVGLayer cg = new SVGLayer(this.svg);
        return cg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 13;
        result = prime * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SVGCustomGraphics)) {
            return false;
        }
        SVGCustomGraphics other = (SVGCustomGraphics)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    static {
        try (Scanner scan = new Scanner(new BufferedInputStream(SVGCustomGraphics.class.getResourceAsStream(DEF_IMAGE_FILE)));){
            StringBuilder sb = new StringBuilder();
            while (scan.hasNextLine()) {
                sb.append(scan.nextLine());
                sb.append("\n");
            }
            DEF_IMAGE = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

