/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.cytoscape.cg.model.CustomGraphics2Manager;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2Factory;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;
import org.cytoscape.view.vizmap.mappings.ValueTranslator;

public class CustomGraphicsTranslator
implements ValueTranslator<String, CyCustomGraphics> {
    private static final String SVG_DATA_URL_PREFIX = "data:image/svg+xml;utf8,";
    private static final Pattern SVG_PATTERN_1 = Pattern.compile("<svg[^>]*>", 2);
    private static final Pattern SVG_PATTERN_2 = Pattern.compile("</svg>", 2);
    private final CustomGraphicsManager cgMgr;
    private final CustomGraphics2Manager cg2Mgr;
    private final Map<String, String> mimeTypes = new WeakHashMap<String, String>();

    public CustomGraphicsTranslator(CustomGraphicsManager cgMgr, CustomGraphics2Manager cg2Mgr) {
        this.cgMgr = cgMgr;
        this.cg2Mgr = cg2Mgr;
    }

    public CyCustomGraphics translate(String inputValue) {
        CyCustomGraphics cg = this.translateURL(inputValue);
        if (cg == null) {
            for (CyCustomGraphics2Factory<? extends CustomGraphicLayer> cyCustomGraphics2Factory : this.cg2Mgr.getAllCustomGraphics2Factories()) {
                if (cyCustomGraphics2Factory.getId() == null || !inputValue.startsWith(cyCustomGraphics2Factory.getId() + ":")) continue;
                cg = cyCustomGraphics2Factory.getInstance(inputValue.substring(cyCustomGraphics2Factory.getId().length() + 1));
                break;
            }
        }
        if (cg == null) {
            for (CyCustomGraphicsFactory cyCustomGraphicsFactory : this.cgMgr.getAllCustomGraphicsFactories()) {
                if (cyCustomGraphicsFactory.getPrefix() == null || !inputValue.startsWith(cyCustomGraphicsFactory.getPrefix() + ":")) continue;
                cg = cyCustomGraphicsFactory.getInstance(inputValue.substring(cyCustomGraphicsFactory.getPrefix().length() + 1));
                break;
            }
        }
        return cg;
    }

    public Class<CyCustomGraphics> getTranslatedValueType() {
        return CyCustomGraphics.class;
    }

    private CyCustomGraphics translateURL(String input) {
        if (input == null) {
            return null;
        }
        if (((String)(input = ((String)input).trim())).isEmpty()) {
            return null;
        }
        try {
            boolean isDataURL = this.isDataURL((String)input);
            if (!isDataURL && CustomGraphicsTranslator.isSVGText((String)input)) {
                input = SVG_DATA_URL_PREFIX + (String)input;
                isDataURL = true;
            }
            if (isDataURL) {
                String type = ((String)input).substring(((String)input).indexOf(":") + 1, ((String)input).indexOf(";"));
                for (CyCustomGraphicsFactory factory : this.cgMgr.getAllCustomGraphicsFactories()) {
                    CyCustomGraphics cg;
                    if (!factory.supportsMime(type) || (cg = factory.getInstance((String)input)) == null) continue;
                    return cg;
                }
            } else {
                URL url = new URL((String)input);
                String type = this.mimeTypes.get(input);
                if (type == null) {
                    URLConnection conn = url.openConnection();
                    if (conn == null) {
                        return null;
                    }
                    type = conn.getContentType();
                    this.mimeTypes.put((String)input, type);
                }
                for (CyCustomGraphicsFactory factory : this.cgMgr.getAllCustomGraphicsFactories()) {
                    CyCustomGraphics cg;
                    if (!factory.supportsMime(type) || (cg = factory.getInstance(url)) == null) continue;
                    return cg;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean isDataURL(String s) {
        return s.startsWith("data:") && s.indexOf(";") > s.indexOf("data:") + 1;
    }

    private static boolean isSVGText(String s) {
        return SVG_PATTERN_1.matcher(s).find() && SVG_PATTERN_2.matcher(s).find();
    }
}

