/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.slf4j.Logger;

public final class ViewUtil {
    public static ImageIcon resizeIcon(ImageIcon icon, int width, int height) {
        Image img = icon.getImage().getScaledInstance(width, height, 16);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return new ImageIcon(bi);
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static void recursiveDo(Component component, Consumer<JComponent> c) {
        if (component instanceof JComponent) {
            c.accept((JComponent)component);
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                ViewUtil.recursiveDo(child, c);
            }
        }
    }

    public static void styleEditorButtons(AbstractButton ... buttons) {
        for (AbstractButton btn : buttons) {
            btn.putClientProperty("JButton.buttonType", "gradient");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{btn});
        }
    }

    public static void styleToolBarButton(AbstractButton btn) {
        ViewUtil.styleToolBarButton(btn, null, true);
    }

    public static void styleToolBarButton(AbstractButton btn, boolean addPadding) {
        ViewUtil.styleToolBarButton(btn, null, addPadding);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font) {
        ViewUtil.styleToolBarButton(btn, font, true);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, boolean addPadding) {
        int hPad = addPadding ? 5 : 0;
        int vPad = addPadding ? 4 : 0;
        ViewUtil.styleToolBarButton(btn, font, hPad, vPad);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, int hPad, int vPad) {
        if (font != null) {
            btn.setFont(font);
        }
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        btn.setContentAreaFilled(false);
        btn.setOpaque(true);
        btn.setHorizontalAlignment(0);
        btn.setVerticalAlignment(0);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(1);
        if (hPad > 0 || vPad > 0) {
            Dimension d = btn.getPreferredSize();
            d = new Dimension(d.width + 2 * hPad, d.height + 2 * vPad);
            btn.setPreferredSize(d);
            btn.setMinimumSize(d);
            btn.setMaximumSize(d);
            btn.setSize(d);
        }
        if (btn instanceof JToggleButton) {
            btn.addItemListener(evt -> ViewUtil.updateToolBarStyle((JToggleButton)btn));
            ViewUtil.updateToolBarStyle((JToggleButton)btn);
        }
    }

    public static void updateToolBarStyle(JToggleButton btn) {
        ViewUtil.updateToolBarStyle(btn, true);
    }

    public static void updateToolBarStyle(JToggleButton btn, boolean showSelectionBorder) {
        Border defBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (btn.isEnabled()) {
            Border selBorder = showSelectionBorder ? BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("CyToggleButton[Selected].borderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1)) : defBorder;
            btn.setBorder(btn.isSelected() ? selBorder : defBorder);
            btn.setBackground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].background") : UIManager.getColor("CyToggleButton.background"));
            btn.setForeground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].foreground") : UIManager.getColor("CyToggleButton.foreground"));
        } else {
            btn.setBorder(defBorder);
            btn.setForeground(UIManager.getColor("ToggleButton.disabledForeground"));
            btn.setBackground(UIManager.getColor("CyToggleButton.unselectedBackground"));
        }
    }

    private ViewUtil() {
    }
}

