/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public static BufferedImage toBufferedImage(Image image) throws InterruptedException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(image, 0);
        tracker.waitForAll();
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, false);
        pixelGrabber.grabPixels();
        ColorModel cm = pixelGrabber.getColorModel();
        int w = pixelGrabber.getWidth();
        int h = pixelGrabber.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage renderedImage = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), new Hashtable());
        renderedImage.getRaster().setDataElements(0, 0, w, h, pixelGrabber.getPixels());
        return renderedImage;
    }

    public static List<AbstractURLImageCustomGraphics> loadImageCustomGraphics(File[] files, CustomGraphicsManager manager) {
        ArrayList<AbstractURLImageCustomGraphics> images = new ArrayList<AbstractURLImageCustomGraphics>();
        for (File file : files) {
            BufferedImage img = null;
            String svg = null;
            try {
                URL url = file.toURI().toURL();
                if (!file.isFile()) continue;
                if (CustomGraphicsUtil.isSVG(url)) {
                    svg = Files.readString(file.toPath());
                } else {
                    img = ImageIO.read(file);
                }
                AbstractURLImageCustomGraphics cg = null;
                if (svg != null) {
                    cg = new SVGCustomGraphics(manager.getNextAvailableID(), url, svg);
                } else if (img != null) {
                    cg = new BitmapCustomGraphics(manager.getNextAvailableID(), url, img);
                }
                if (cg == null) continue;
                images.add(cg);
            }
            catch (Exception e) {
                logger.error("Could not create custom graphics: " + file, (Throwable)e);
            }
        }
        return images;
    }

    private ImageUtil() {
    }
}

