/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.cytoscape.cg.internal.util.ColorUtil;
import org.cytoscape.cg.internal.util.MathUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class GradientEditor
extends JPanel {
    private static final int HPAD = 4;
    private static final int VPAD = 2;
    private static final int BORDER_WIDTH = 2;
    private static final int MARKER_SIZE = 12;
    private static final float[] MAIN_POSITIONS = new float[]{0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f};
    private Color color1 = UIManager.getColor("CyComponent.borderColor");
    private Color color2 = UIManager.getColor("Table.background");
    private Color selColor = UIManager.getColor("Focus.color");
    private Stroke defStroke = new BasicStroke(1.0f);
    private Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    private List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();
    private ControlPoint selected;
    private Polygon marker = new Polygon();
    private int x;
    private int y;
    private int w;
    private int h;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private boolean mouseDragging;
    private final CyServiceRegistrar serviceRegistrar;

    public GradientEditor(List<ControlPoint> points, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.setPoints(points, false);
        this.init();
    }

    public GradientEditor(List<Float> positions, List<Color> colors, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<ControlPoint> points = new ArrayList<ControlPoint>();
        if (positions != null) {
            for (int i = 0; i < positions.size(); ++i) {
                float pos = positions.get(i).floatValue();
                Color c = null;
                if (colors != null && colors.size() > i) {
                    c = colors.get(i);
                }
                points.add(new ControlPoint(c != null ? c : Color.WHITE, pos));
            }
        }
        this.setPoints(points, false);
        this.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        this.repaint(0L);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void addPoint(float pos, Color col) {
        this.addPoint(new ControlPoint(col, pos));
    }

    public void deletePoint() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == 0) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == this.controlPoints.size() - 1) {
            return;
        }
        this.controlPoints.remove(this.selected);
        this.setSelected(null);
        this.repaint(0L);
        this.fireUpdate();
    }

    public void setStart(Color col) {
        this.controlPoints.get(0).setColor(col);
        this.repaint(0L);
    }

    public void setEnd(Color col) {
        this.controlPoints.get(this.controlPoints.size() - 1).setColor(col);
        this.repaint(0L);
    }

    public void addPoint() {
        ControlPoint point = new ControlPoint(Color.WHITE, 0.5f);
        this.addPoint(point);
        ControlPoint oldSelected = this.selected;
        this.selected = point;
        this.repaint(0L);
        this.fireUpdate();
        this.firePropertyChange("selected", oldSelected, this.selected);
    }

    public void editPoint() {
        if (this.selected == null) {
            return;
        }
        CyColorPaletteChooserFactory chooserFactory = (CyColorPaletteChooserFactory)this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
        CyColorPaletteChooser chooser = chooserFactory.getColorPaletteChooser((PaletteType)BrewerType.ANY, false);
        Color col = chooser.showDialog((Component)this, "Colors", null, this.selected.getColor(), 8);
        if (col != null) {
            this.selected.setColor(col);
            this.repaint(0L);
            this.fireUpdate();
        }
    }

    public void clearPoints() {
        for (int i = 1; i < this.controlPoints.size() - 1; ++i) {
            this.controlPoints.remove(1);
        }
        this.repaint(0L);
        this.fireUpdate();
    }

    public int getControlPointCount() {
        return this.controlPoints.size();
    }

    public float getPointPos(int index) {
        return this.controlPoints.get(index).getPosition();
    }

    public Color getColor(int index) {
        return this.controlPoints.get(index).getColor();
    }

    public List<ControlPoint> getControlPoints() {
        return new ArrayList<ControlPoint>(this.controlPoints);
    }

    public List<Float> getPositions() {
        ArrayList<Float> positions = new ArrayList<Float>();
        int size = this.controlPoints.size();
        for (int i = 0; i < size; ++i) {
            ControlPoint cp = this.controlPoints.get(i);
            float pos = cp.getPosition();
            if (i < size - 1 && pos == this.controlPoints.get(i + 1).getPosition()) continue;
            positions.add(Float.valueOf(pos));
        }
        return positions;
    }

    public float[] getPositionsAsArray() {
        List<Float> positions = this.getPositions();
        float[] array = new float[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            array[i] = positions.get(i).floatValue();
        }
        return array;
    }

    public List<Color> getColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        int size = this.controlPoints.size();
        for (int i = 0; i < size; ++i) {
            ControlPoint cp = this.controlPoints.get(i);
            float pos = cp.getPosition();
            if (i < size - 1 && pos == this.controlPoints.get(i + 1).getPosition()) continue;
            colors.add(cp.getColor());
        }
        return colors;
    }

    public Color[] getColorsAsArray() {
        List<Color> colors = this.getColors();
        return colors.toArray(new Color[colors.size()]);
    }

    public void setPoints(List<ControlPoint> points) {
        this.setPoints(points, true);
    }

    public ControlPoint getSelected() {
        return this.selected;
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.setMinimumSize(new Dimension(100, 50));
        this.setPreferredSize(new Dimension(200, 50));
        this.setFocusable(true);
        this.setKeyBindings();
        this.marker.addPoint(0, 0);
        this.marker.addPoint(6, 12);
        this.marker.addPoint(-6, 12);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GradientEditor.this.selectPoint(e.getX(), e.getY());
                GradientEditor.this.repaint(0L);
                if (e.getClickCount() == 2) {
                    GradientEditor.this.editPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GradientEditor.this.mouseDragging = false;
                GradientEditor.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GradientEditor.this.mouseDragging = true;
                GradientEditor.this.movePoint(e);
                GradientEditor.this.repaint(0L);
            }
        });
    }

    private void addPoint(ControlPoint point) {
        float pos = point.getPosition();
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            ControlPoint next;
            ControlPoint now = this.controlPoints.get(i);
            ControlPoint controlPoint = next = i < this.controlPoints.size() - 1 ? this.controlPoints.get(i + 1) : null;
            if (!(pos >= now.getPosition()) || next != null && !(pos < next.getPosition())) continue;
            int newIdx = next == null ? i : i + 1;
            this.controlPoints.add(newIdx, point);
            break;
        }
        this.repaint(0L);
    }

    private void setPoints(List<ControlPoint> points, boolean update) {
        this.setSelected(null);
        this.controlPoints.clear();
        if (points == null || points.isEmpty()) {
            this.controlPoints.add(new ControlPoint(Color.WHITE, 0.0f));
            this.controlPoints.add(new ControlPoint(Color.BLACK, 1.0f));
        } else {
            for (int i = 0; i < points.size() - 1; ++i) {
                if (i == 0) {
                    if (points.get(i) != null) {
                        this.controlPoints.add(new ControlPoint(points.get(i).getColor(), 0.0f));
                    } else {
                        this.controlPoints.add(new ControlPoint(Color.WHITE, 0.0f));
                    }
                    if (points.get(points.size() - 1) != null) {
                        this.controlPoints.add(new ControlPoint(points.get(points.size() - 1).getColor(), 1.0f));
                        continue;
                    }
                    this.controlPoints.add(new ControlPoint(Color.BLACK, 1.0f));
                    continue;
                }
                ControlPoint cp = points.get(i);
                if (cp == null) continue;
                this.addPoint(cp.getPosition(), cp.getColor());
            }
        }
        if (update) {
            this.repaint(0L);
            this.fireUpdate();
        }
    }

    private void fireUpdate() {
        ActionEvent event = new ActionEvent(this, 0, "");
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(event);
        }
    }

    private boolean checkPoint(int mx, int my, ControlPoint pt) {
        int shift = 0;
        if (pt == this.controlPoints.get(0)) {
            shift = -2;
        } else if (pt == this.controlPoints.get(this.controlPoints.size() - 1)) {
            shift = 2;
        }
        int dx = (int)Math.abs((float)(12 + shift) + (float)this.w * pt.getPosition() - (float)mx);
        int dy = Math.abs(this.y + this.h + 1 + 6 - my);
        return dx < 6 && dy < 7;
    }

    private void selectPoint(int mx, int my) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = this.controlPoints.size() - 2; i > 0; --i) {
            if (!this.checkPoint(mx, my, this.controlPoints.get(i))) continue;
            this.setSelected(this.controlPoints.get(i));
            this.requestFocusInWindow();
            return;
        }
        if (this.checkPoint(mx, my, this.controlPoints.get(0))) {
            this.setSelected(this.controlPoints.get(0));
            this.requestFocusInWindow();
            return;
        }
        if (this.checkPoint(mx, my, this.controlPoints.get(this.controlPoints.size() - 1))) {
            this.setSelected(this.controlPoints.get(this.controlPoints.size() - 1));
            this.requestFocusInWindow();
            return;
        }
        this.setSelected(null);
    }

    private void setSelected(ControlPoint selected) {
        if (this.selected != selected) {
            ControlPoint oldValue = this.selected;
            this.selected = selected;
            this.firePropertyChange("selected", oldValue, selected);
        }
    }

    private void movePoint(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == 0) {
            return;
        }
        if (this.controlPoints.indexOf(this.selected) == this.controlPoints.size() - 1) {
            return;
        }
        float newPos = (float)(e.getX() - 10) / (float)this.w;
        newPos = Math.min(1.0f, newPos);
        newPos = Math.max(0.0f, newPos);
        if (e.isShiftDown()) {
            newPos = MathUtil.findNearestNumber(MAIN_POSITIONS, newPos);
        }
        this.selected.setPosition(newPos);
        this.controlPoints.remove(this.selected);
        this.addPoint(this.selected);
        this.fireUpdate();
    }

    private void setKeyBindings() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "VK_DELETE");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "VK_BACK_SPACE");
        actionMap.put("VK_DELETE", new KeyAction("VK_DELETE"));
        actionMap.put("VK_BACK_SPACE", new KeyAction("VK_BACK_SPACE"));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        Insets insets = this.getInsets();
        int bw = 1;
        this.x = 10;
        this.y = 2;
        this.w = this.getWidth() - insets.left - insets.right - 8 - 12;
        this.h = this.getHeight() - insets.top - insets.bottom - 4 - 12;
        g2.setColor(this.color1);
        g2.setStroke(new BasicStroke(bw));
        g2.drawRect(this.x, this.y, this.w, this.h);
        this.x += bw;
        this.y += bw;
        this.w -= 2 * bw;
        this.h -= 2 * bw;
        g2.setColor(this.color2);
        g2.fillRect(this.x, this.y, this.w, this.h);
        this.x += bw;
        this.y += bw;
        this.w -= 2 * bw;
        this.h -= 2 * bw;
        LinearGradientPaint paint = new LinearGradientPaint(new Point2D.Double(this.x, this.y), new Point2D.Double(this.x + this.w, this.y), this.getPositionsAsArray(), this.getColorsAsArray());
        g2.setPaint(paint);
        g2.fillRect(this.x, this.y, this.w, this.h);
        if (this.mouseDragging) {
            float mpx = (float)(this.x - bw / 2) + (float)this.w * 0.5f;
            g2.translate(mpx, (double)this.y);
            g2.setStroke(this.dashedStroke);
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawLine(0, 0, 0, this.h);
            g2.setStroke(this.defStroke);
            g2.translate(-mpx, (double)(-this.y));
        }
        this.paintMarker(g2, this.controlPoints.get(0));
        this.paintMarker(g2, this.controlPoints.get(this.controlPoints.size() - 1));
        for (int i = 1; i < this.controlPoints.size() - 1; ++i) {
            this.paintMarker(g2, this.controlPoints.get(i));
        }
        g2.dispose();
    }

    private void paintMarker(Graphics g, ControlPoint pt) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float py = this.y + this.h;
        float px = 12.0f + (float)this.w * pt.getPosition();
        boolean bw = true;
        Color borderColor = pt == this.selected ? this.selColor : this.color1;
        BasicStroke stroke = new BasicStroke(pt == this.selected ? (float)bw * 1.5f : (float)bw);
        ControlPoint firstPt = this.controlPoints.get(0);
        ControlPoint lastPt = this.controlPoints.get(this.controlPoints.size() - 1);
        if (pt == firstPt || pt == lastPt) {
            if (pt == firstPt) {
                g2.translate(px - 2.0f, py);
            } else {
                g2.translate(px + 2.0f, py);
            }
            g2.setColor(pt.getColor());
            g2.fillOval(-6, 0, 12, 12);
            g2.setColor(borderColor);
            g2.setStroke(stroke);
            g2.drawOval(-6, 0, 12, 12);
        } else {
            g2.translate(px, py);
            g2.setColor(pt.getColor());
            g2.fillPolygon(this.marker);
            g2.setColor(borderColor);
            g2.setStroke(stroke);
            g2.drawPolygon(this.marker);
        }
        g2.dispose();
    }

    public static class ControlPoint {
        private Color color;
        private float position;

        public ControlPoint() {
            this(Color.WHITE, 0.0f);
        }

        public ControlPoint(Color color, float position) {
            if (color == null) {
                throw new IllegalArgumentException("'color' must not be null.");
            }
            this.setColor(color);
            this.setPosition(position);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public float getPosition() {
            return this.position;
        }

        public void setPosition(float position) {
            this.position = position;
        }

        public String toString() {
            return this.getPosition() + ":" + ColorUtil.toHexString(this.getColor());
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_DELETE = "VK_DELETE";
        static final String VK_BACK_SPACE = "VK_BACK_SPACE";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (this.isEnabled() && (cmd.equals(VK_DELETE) || cmd.equals(VK_BACK_SPACE)) && GradientEditor.this.selected != null) {
                GradientEditor.this.deletePoint();
            }
        }
    }
}

