/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.cg.internal.util.ColorKeyword;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static List<Color> parseColorList(String[] inputArray) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String colorString : inputArray) {
            Color c = ColorUtil.parseColor(colorString = colorString.trim());
            if (c != null) continue;
            colors.add(c);
        }
        return colors;
    }

    public static Color parseColor(String input) {
        Color color = null;
        if (input.matches("^#([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})$")) {
            int r = Integer.parseInt(input.substring(1, 3), 16);
            int g = Integer.parseInt(input.substring(3, 5), 16);
            int b = Integer.parseInt(input.substring(5, 7), 16);
            if (input.length() > 7) {
                int a = Integer.parseInt(input.substring(7, 9), 16);
                color = new Color(r, g, b, a);
            } else {
                color = new Color(r, g, b);
            }
        } else {
            color = ColorKeyword.getColor(input);
        }
        return color;
    }

    public static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    public static List<Color> getContrastingColors(List<Color> colors) {
        ArrayList<Color> list = new ArrayList<Color>();
        if (colors != null) {
            for (Color c : colors) {
                list.add(ColorUtil.getContrastingColor(c));
            }
        }
        return list;
    }

    public static String toHexString(Color color) {
        int rgb = color.getRGB();
        String hex = String.format("#%06X", 0xFFFFFF & rgb);
        return hex;
    }
}

