/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.ui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.util.ImageCustomGraphicsSelector;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CustomGraphicsManagerDialog
extends JDialog {
    private JButton closeButton;
    private ImageCustomGraphicsSelector imageSelector;
    private final CyServiceRegistrar serviceRegistrar;

    public CustomGraphicsManagerDialog(Window owner, CustomGraphicsManager manager, CyServiceRegistrar serviceRegistrar) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.serviceRegistrar = serviceRegistrar;
        this.init();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void init() {
        this.setTitle("Image Manager");
        this.setMinimumSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(600, 600));
        JPanel bottomPnl = LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.getCloseButton());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getImageSelector(), -1, -1, Short.MAX_VALUE).addComponent(bottomPnl, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getImageSelector(), -1, -1, Short.MAX_VALUE).addComponent(bottomPnl));
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)this.getCloseButton().getAction());
        this.pack();
    }

    private ImageCustomGraphicsSelector getImageSelector() {
        if (this.imageSelector == null) {
            this.imageSelector = new ImageCustomGraphicsSelector(true, this.serviceRegistrar);
            this.imageSelector.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        }
        return this.imageSelector;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomGraphicsManagerDialog.this.dispose();
                }
            });
        }
        return this.closeButton;
    }
}

