/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.task;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.cytoscape.cg.internal.util.ImageUtil;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveUserImagesTask
implements Task {
    private static final int TIMEOUT = 1000;
    private static final int NUM_THREADS = 4;
    private static final String METADATA_FILE = "image_metadata.props";
    private final File location;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public SaveUserImagesTask(File location, CyServiceRegistrar serviceRegistrar) {
        this.location = location;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Save User Images");
        tm.setStatusMessage("Saving image library to your local disk.\n\nPlease wait...");
        tm.setProgress(0.0);
        if (this.location.exists()) {
            FileUtils.cleanDirectory((File)this.location);
        } else {
            this.location.mkdir();
        }
        long startTime = System.currentTimeMillis();
        ExecutorService exService = Executors.newFixedThreadPool(4);
        CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        for (CyCustomGraphics cg : manager.getAllPersistantCustomGraphics()) {
            if (cg instanceof SVGCustomGraphics) {
                String svg = ((SVGCustomGraphics)cg).getSVG();
                if (svg == null || svg.isBlank()) continue;
                try {
                    exService.submit(new SaveSVGImageTask(this.location, cg.getIdentifier().toString(), svg));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            Image img = cg.getRenderedImage();
            if (img == null) continue;
            try {
                exService.submit(new SavePNGImageTask(this.location, cg.getIdentifier().toString(), ImageUtil.toBufferedImage(img)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            exService.shutdown();
            exService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            manager.getMetadata().store(new FileOutputStream(new File(this.location, METADATA_FILE)), "Image Metadata");
        }
        catch (IOException e) {
            throw new IOException("Could not save image metadata file.", e);
        }
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("Image saving process finished in " + sec + " sec.");
    }

    public void cancel() {
    }

    private final class SaveSVGImageTask
    implements Callable<String> {
        private final File imageHome;
        private String fileName;
        private final String svg;

        public SaveSVGImageTask(File imageHomeDirectory, String fileName, String svg) {
            this.imageHome = imageHomeDirectory;
            this.fileName = fileName;
            this.svg = svg;
        }

        @Override
        public String call() throws Exception {
            logger.debug("  Saving SVG Image: " + this.fileName);
            if (!this.fileName.endsWith(".svg")) {
                this.fileName = this.fileName + ".svg";
            }
            File file = new File(this.imageHome, this.fileName);
            try (FileWriter writer = new FileWriter(file);){
                file.createNewFile();
                writer.write(this.svg);
            }
            catch (IOException e) {
                logger.error("Cannot save SVG image " + file.getAbsolutePath(), (Throwable)e);
            }
            return file.toString();
        }
    }

    private final class SavePNGImageTask
    implements Callable<String> {
        private final File imageHome;
        private String fileName;
        private final BufferedImage image;

        public SavePNGImageTask(File imageHomeDirectory, String fileName, BufferedImage image) {
            this.imageHome = imageHomeDirectory;
            this.fileName = fileName;
            this.image = image;
        }

        @Override
        public String call() throws Exception {
            logger.debug("  Saving PNG Image: " + this.fileName);
            if (!this.fileName.endsWith(".png")) {
                this.fileName = this.fileName + ".png";
            }
            File file = new File(this.imageHome, this.fileName);
            try {
                file.createNewFile();
                ImageIO.write((RenderedImage)this.image, "PNG", file);
            }
            catch (IOException e) {
                logger.error("Cannot save PNG image " + file.getAbsolutePath(), (Throwable)e);
            }
            return file.toString();
        }
    }
}

