/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.task;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedEvent;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.model.Taggable;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreImagesTask
implements Task {
    private final ExecutorService imageLoaderService;
    private static final int TIMEOUT = 1000;
    private static final int NUM_THREADS = 8;
    private static final String METADATA_FILE = "image_metadata.props";
    private File imageHomeDirectory;
    private final CyServiceRegistrar serviceRegistrar;
    private static final String PNG_EXT = ".png";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public RestoreImagesTask(File imageLocation, CyServiceRegistrar serviceRegistrar) {
        this.imageHomeDirectory = imageLocation;
        this.serviceRegistrar = serviceRegistrar;
        this.imageLoaderService = Executors.newFixedThreadPool(8);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Load Image Library");
        tm.setStatusMessage("Loading image library from local disk...");
        tm.setProgress(0.0);
        long startTime = System.currentTimeMillis();
        CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        this.restoreImages(manager);
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("Image saving process finished in " + sec + " sec.");
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).fireEvent((CyEvent)new CustomGraphicsLibraryUpdatedEvent(manager));
    }

    private void restoreImages(CustomGraphicsManager manager) {
        ExecutorCompletionService<BufferedImage> cs = new ExecutorCompletionService<BufferedImage>(this.imageLoaderService);
        this.imageHomeDirectory.mkdir();
        long startTime = System.currentTimeMillis();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(new File(this.imageHomeDirectory, METADATA_FILE)));
            logger.info("Custom Graphics Image property file loaded from: " + this.imageHomeDirectory);
        }
        catch (Exception e) {
            logger.info("Custom Graphics Metadata was not found. (This is normal for the first time.)");
            return;
        }
        if (this.imageHomeDirectory != null && this.imageHomeDirectory.isDirectory()) {
            File[] imageFiles = this.imageHomeDirectory.listFiles();
            HashMap<Future<BufferedImage>, String> nameMap = new HashMap<Future<BufferedImage>, String>();
            HashMap<Future<BufferedImage>, Long> idMap = new HashMap<Future<BufferedImage>, Long>();
            HashMap<Future<BufferedImage>, URL> urlMap = new HashMap<Future<BufferedImage>, URL>();
            HashMap tagMap = new HashMap();
            HashSet<File> validFiles = new HashSet<File>();
            for (File file : imageFiles) {
                String[] tagParts;
                String[] imageProps;
                String fileName;
                String key;
                String value;
                if (!manager.isSupportedImageFile(file) || (value = prop.getProperty(key = (fileName = file.getName()).split("\\.")[0])) == null || !value.contains("URLImageCustomGraphics") && !value.contains("SVGCustomGraphics") || (imageProps = value.split(",")) == null || imageProps.length < 2) continue;
                String name = imageProps[2];
                if (name.contains("___")) {
                    name = name.replace("___", ",");
                }
                URL url = null;
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.error("Cannot create URL from image file " + file, (Throwable)e);
                    continue;
                }
                Callable<BufferedImage> task = RestoreImagesTask.isPNG(file) ? new LoadPNGImageTask(url) : new LoadSVGImageTask(url);
                Future<BufferedImage> future = cs.submit(task);
                validFiles.add(file);
                nameMap.put(future, name);
                idMap.put(future, Long.parseLong(imageProps[1]));
                urlMap.put(future, url);
                String tagStr = null;
                if (imageProps.length <= 3) continue;
                tagStr = imageProps[3];
                TreeSet<String> tags = new TreeSet<String>();
                for (String tag : tagParts = tagStr.split("\\|")) {
                    tags.add(tag.trim());
                }
                tagMap.put(future, tags);
            }
            for (Map.Entry entry : urlMap.entrySet()) {
                try {
                    AbstractURLImageCustomGraphics cg;
                    Future future = cs.take();
                    Object image = future.get();
                    if (!(image instanceof BufferedImage) && !(image instanceof String)) continue;
                    Long id = (Long)idMap.get(future);
                    String name = (String)nameMap.get(future);
                    URL url = null;
                    try {
                        url = new URL(name);
                    }
                    catch (MalformedURLException me) {
                        url = (URL)urlMap.get(future);
                    }
                    AbstractURLImageCustomGraphics abstractURLImageCustomGraphics = cg = image instanceof BufferedImage ? new BitmapCustomGraphics(id, name, url, (BufferedImage)image) : new SVGCustomGraphics(id, name, url, (String)image);
                    if (cg instanceof Taggable && tagMap.get(future) != null) {
                        cg.getTags().addAll((Collection)tagMap.get(future));
                    }
                    if (url == null) continue;
                    manager.addCustomGraphics(cg, url);
                }
                catch (Exception e) {
                    logger.error("Cannot load image file " + entry.getValue(), (Throwable)e);
                }
            }
        }
        try {
            this.imageLoaderService.shutdown();
            this.imageLoaderService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("Image loading process finished in " + sec + " sec.");
        logger.info("Currently,  " + (manager.getAllCustomGraphics().size() - 1) + " images are available.");
    }

    public void cancel() {
    }

    private static boolean isPNG(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(PNG_EXT);
    }

    private final class LoadPNGImageTask
    implements Callable<BufferedImage> {
        private final URL url;

        public LoadPNGImageTask(URL url) {
            if (url == null) {
                throw new IllegalStateException("URL string cannot be null.");
            }
            this.url = url;
        }

        @Override
        public BufferedImage call() throws Exception {
            return ImageIO.read(this.url);
        }
    }

    private final class LoadSVGImageTask
    implements Callable<String> {
        private final URL url;

        public LoadSVGImageTask(URL url) {
            if (url == null) {
                throw new IllegalStateException("URL string cannot be null.");
            }
            this.url = url;
        }

        @Override
        public String call() throws Exception {
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
    }
}

