/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.cg.event.CustomGraphicsReadyToBeLoadedEvent;
import org.cytoscape.cg.event.CustomGraphicsReadyToBeLoadedListener;
import org.cytoscape.cg.internal.image.MissingImageCustomGraphics;
import org.cytoscape.cg.internal.task.RestoreImagesTask;
import org.cytoscape.cg.internal.task.SaveGraphicsToSessionTaskFactory;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.CGComparator;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.IDGenerator;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomGraphicsManagerImpl
implements CustomGraphicsManager,
CyStartListener,
SessionAboutToBeSavedListener,
SessionAboutToBeLoadedListener,
CustomGraphicsReadyToBeLoadedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String APP_NAME = "org.cytoscape.ding.customgraphicsmgr";
    private static final String TEMP_DIR_KEY = "java.io.tmpdir";
    private static final String CYS_IMG_DIR_NAME = "cys-images";
    private static final String PNG_EXT = ".png";
    private static final String SVG_EXT = ".svg";
    private final Map<Long, CyCustomGraphics> graphicsMap = new ConcurrentHashMap<Long, CyCustomGraphics>(16, 0.75f, 2);
    protected final Map<URL, Long> sourceMap = new ConcurrentHashMap<URL, Long>(16, 0.75f, 2);
    private final File imageHomeDirectory;
    private final Set<MissingImageCustomGraphics<?>> missingImageCustomGraphicsSet;
    private final Set<Long> usedCustomGraphicsSet;
    private final Map<String, CyCustomGraphicsFactory> factoryMap;
    private final Map<CyCustomGraphicsFactory, Map<?, ?>> factoryPropsMap;
    private final CyServiceRegistrar serviceRegistrar;
    private static CustomGraphicsManager instance;

    public CustomGraphicsManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.missingImageCustomGraphicsSet = new HashSet();
        this.usedCustomGraphicsSet = new HashSet<Long>();
        this.factoryMap = new HashMap<String, CyCustomGraphicsFactory>();
        this.factoryPropsMap = new HashMap();
        File parentDir = new File(System.getProperty(TEMP_DIR_KEY));
        this.imageHomeDirectory = new File(parentDir, CYS_IMG_DIR_NAME);
        instance = this;
    }

    public static CustomGraphicsManager getInstance() {
        return instance;
    }

    @Override
    public void addCustomGraphicsFactory(CyCustomGraphicsFactory factory, Map<?, ?> props) {
        if (factory == null) {
            return;
        }
        String key = (String)props.get("SUPPORTED_CLASS_ID");
        if (key == null) {
            key = factory.getSupportedClass().getName();
        }
        this.factoryMap.put(key, factory);
        this.factoryPropsMap.put(factory, props);
    }

    @Override
    public void removeCustomGraphicsFactory(CyCustomGraphicsFactory factory, Map<?, ?> props) {
        if (factory == null) {
            return;
        }
        Iterator<Map.Entry<String, CyCustomGraphicsFactory>> iter = this.factoryMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, CyCustomGraphicsFactory> entry = iter.next();
            if (!factory.equals(entry.getValue())) continue;
            iter.remove();
        }
        this.factoryPropsMap.remove(factory);
    }

    @Override
    public CyCustomGraphicsFactory getCustomGraphicsFactory(Class<? extends CyCustomGraphics> cls) {
        return this.factoryMap.containsKey(cls.getName()) ? this.factoryMap.get(cls.getName()) : null;
    }

    @Override
    public CyCustomGraphicsFactory getCustomGraphicsFactory(String className) {
        return this.factoryMap.containsKey(className) ? this.factoryMap.get(className) : null;
    }

    @Override
    public Collection<CyCustomGraphicsFactory> getAllCustomGraphicsFactories() {
        return this.factoryMap.values();
    }

    @Override
    public Collection<CyCustomGraphicsFactory> getCustomGraphicsFactories(Class<? extends CyIdentifiable> targetType) {
        Set<CyCustomGraphicsFactory> col = null;
        Collection<CyCustomGraphicsFactory> all = this.factoryMap.values();
        if (all != null) {
            col = new HashSet();
            for (CyCustomGraphicsFactory f : all) {
                if (!f.getSupportedTargetTypes().contains(targetType)) continue;
                col.add(f);
            }
        }
        return col != null ? col : Collections.emptySet();
    }

    @Override
    public void addCustomGraphics(CyCustomGraphics graphics, URL source) {
        if (graphics == null) {
            throw new IllegalArgumentException("Custom Graphics and its ID should not be null.");
        }
        if (graphics.getIdentifier() == null) {
            graphics.setIdentifier(this.getNextAvailableID());
        }
        if (source != null) {
            this.sourceMap.put(source, graphics.getIdentifier());
        }
        this.graphicsMap.put(graphics.getIdentifier(), graphics);
    }

    @Override
    public void removeCustomGraphics(Long id) {
        CyCustomGraphics cg = this.graphicsMap.get(id);
        if (cg != null && cg != NullCustomGraphics.getNullObject()) {
            this.graphicsMap.remove(id);
            this.usedCustomGraphicsSet.remove(id);
        }
    }

    @Override
    public CyCustomGraphics getCustomGraphicsByID(Long id) {
        return this.graphicsMap.get(id);
    }

    @Override
    public CyCustomGraphics getCustomGraphicsBySourceURL(URL sourceURL) {
        Long id = this.sourceMap.get(sourceURL);
        if (id != null) {
            return this.graphicsMap.get(id);
        }
        return null;
    }

    @Override
    public Collection<CyCustomGraphics> getAllCustomGraphics() {
        return this.getAllCustomGraphics(false);
    }

    @Override
    public Collection<CyCustomGraphics> getAllCustomGraphics(boolean sorted) {
        if (!sorted) {
            return this.graphicsMap.values();
        }
        ArrayList<CyCustomGraphics> values = new ArrayList<CyCustomGraphics>(this.graphicsMap.values());
        Collections.sort(values, new CGComparator());
        return values;
    }

    @Override
    public Collection<CyCustomGraphics> getAllPersistantCustomGraphics() {
        HashSet<CyCustomGraphics> cgSet = new HashSet<CyCustomGraphics>();
        for (CyCustomGraphics cg : this.getAllCustomGraphics()) {
            AbstractURLImageCustomGraphics urlCG;
            if (!(cg instanceof AbstractURLImageCustomGraphics) || (urlCG = (AbstractURLImageCustomGraphics)cg).getSourceURL() != null && urlCG.getSourceURL().toString().startsWith("bundle:")) continue;
            cgSet.add(cg);
        }
        return cgSet;
    }

    @Override
    public void removeAllCustomGraphics() {
        this.graphicsMap.clear();
        this.sourceMap.clear();
        this.usedCustomGraphicsSet.clear();
        this.missingImageCustomGraphicsSet.clear();
    }

    @Override
    public Properties getMetadata() {
        Properties props = new Properties();
        for (CyCustomGraphics cg : this.graphicsMap.values()) {
            props.setProperty(cg.getIdentifier().toString(), cg.toSerializableString());
        }
        return props;
    }

    @Override
    public SortedSet<Long> getIDSet() {
        return new TreeSet<Long>(this.graphicsMap.keySet());
    }

    @Override
    public boolean isUsedInCurrentSession(CyCustomGraphics graphics) {
        return graphics != null && this.usedCustomGraphicsSet.contains(graphics.getIdentifier());
    }

    @Override
    public void setUsedInCurrentSession(CyCustomGraphics graphics, Boolean isUsed) {
        if (isUsed == null || graphics == null) {
            return;
        }
        if (isUsed.booleanValue()) {
            this.usedCustomGraphicsSet.add(graphics.getIdentifier());
        } else {
            this.usedCustomGraphicsSet.remove(graphics.getIdentifier());
        }
    }

    public void handleEvent(CyStartEvent e) {
        this.restoreImages();
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        SaveGraphicsToSessionTaskFactory factory = new SaveGraphicsToSessionTaskFactory(this.imageHomeDirectory, e, this.serviceRegistrar);
        try {
            ((SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class)).execute(factory.createTaskIterator());
        }
        catch (Exception ex) {
            logger.error("Could not save images to .", (Throwable)ex);
        }
    }

    public void handleEvent(SessionAboutToBeLoadedEvent evt) {
        File[] files;
        this.removeAllCustomGraphics();
        IDGenerator.getIDGenerator().initCounter(0L);
        File tmpDir = new File(System.getProperty(TEMP_DIR_KEY));
        for (File f : files = tmpDir.listFiles()) {
            try {
                if (!this.isSupportedImageFile(f)) continue;
                f.delete();
            }
            catch (Exception e) {
                logger.error("Cannot delete temporary image: " + f.getName(), (Throwable)e);
            }
        }
        File cysImgDir = new File(tmpDir, CYS_IMG_DIR_NAME);
        try {
            if (cysImgDir.exists()) {
                FileUtils.cleanDirectory((File)cysImgDir);
            }
        }
        catch (Exception e) {
            logger.error("Cannot clean cys-images directory", (Throwable)e);
        }
    }

    @Override
    public void handleEvent(CustomGraphicsReadyToBeLoadedEvent e) {
        List files;
        Map filesMap;
        CySession sess = e.getLoadedSession();
        if (sess != null && (filesMap = sess.getAppFileListMap()) != null && (files = (List)filesMap.get(APP_NAME)) != null && files.size() != 0) {
            File imagesDir = ((File)files.get(0)).getParentFile();
            TaskIterator taskIterator = new TaskIterator(new Task[]{new RestoreImagesTask(imagesDir, this.serviceRegistrar)});
            taskIterator.append((Task)new ReloadMissingImagesTask(sess.getNetworkViews()));
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(taskIterator);
        }
    }

    @Override
    public Long getNextAvailableID() {
        Long key = IDGenerator.getIDGenerator().getNextId();
        while (this.graphicsMap.get(key) != null) {
            key = IDGenerator.getIDGenerator().getNextId();
        }
        return key;
    }

    @Override
    public void addMissingImageCustomGraphics(MissingImageCustomGraphics<?> cg) {
        this.missingImageCustomGraphicsSet.add(cg);
    }

    @Override
    public Collection<MissingImageCustomGraphics<?>> reloadMissingImageCustomGraphics() {
        HashSet reloadedSet = new HashSet();
        for (MissingImageCustomGraphics<?> mcg : this.missingImageCustomGraphicsSet) {
            AbstractURLImageCustomGraphics<?> cg = mcg.reloadImage();
            if (cg == null) continue;
            reloadedSet.add(mcg);
        }
        this.missingImageCustomGraphicsSet.removeAll(reloadedSet);
        return reloadedSet;
    }

    @Override
    public boolean isSupportedImageFile(File file) {
        String name = file.getName().toLowerCase();
        return file.isFile() && (name.endsWith(PNG_EXT) || name.endsWith(SVG_EXT));
    }

    private void restoreImages() {
        TaskIterator taskIterator = new TaskIterator(new Task[]{new RestoreImagesTask(this.imageHomeDirectory, this.serviceRegistrar)});
        ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(taskIterator);
    }

    private class ReloadMissingImagesTask
    implements Task {
        private boolean canceled;
        private final Set<CyNetworkView> networkViews;
        private final String[] nodeCGIdentifiers = new String[]{"NODE_CUSTOMGRAPHICS_1", "NODE_CUSTOMGRAPHICS_2", "NODE_CUSTOMGRAPHICS_3", "NODE_CUSTOMGRAPHICS_4", "NODE_CUSTOMGRAPHICS_5", "NODE_CUSTOMGRAPHICS_6", "NODE_CUSTOMGRAPHICS_7", "NODE_CUSTOMGRAPHICS_8", "NODE_CUSTOMGRAPHICS_9"};
        private final String[] columnCGIdentifiers = new String[]{"CELL_CUSTOMGRAPHICS"};

        public ReloadMissingImagesTask(Set<CyNetworkView> networkViews) {
            this.networkViews = networkViews;
        }

        public void run(TaskMonitor tm) throws Exception {
            Collection<MissingImageCustomGraphics<?>> reloaded = CustomGraphicsManagerImpl.this.reloadMissingImageCustomGraphics();
            if (!reloaded.isEmpty() && this.networkViews != null) {
                RenderingEngineManager rendererManager = (RenderingEngineManager)CustomGraphicsManagerImpl.this.serviceRegistrar.getService(RenderingEngineManager.class);
                VisualLexicon netLexicon = rendererManager.getDefaultVisualLexicon();
                Set<VisualProperty<?>> set1 = this.getVisualProperties(netLexicon, CyNode.class, this.nodeCGIdentifiers);
                this.reloadImages(reloaded, set1);
                VisualLexicon tableLexicon = rendererManager.getDefaultTableVisualLexicon();
                Set<VisualProperty<?>> set2 = this.getVisualProperties(tableLexicon, CyColumn.class, this.columnCGIdentifiers);
                this.reloadImages(reloaded, set2);
            }
        }

        public void cancel() {
            this.canceled = true;
        }

        private Set<VisualProperty<?>> getVisualProperties(VisualLexicon lexicon, Class<?> type, String[] identifiers) {
            HashSet props = new HashSet();
            for (String id : identifiers) {
                VisualProperty vp = lexicon.lookup(type, id);
                if (vp == null) continue;
                props.add(vp);
            }
            return props;
        }

        private void reloadImages(Collection<MissingImageCustomGraphics<?>> reloaded, Set<VisualProperty<?>> props) {
            HashSet<VisualStyle> updatedStyles = new HashSet<VisualStyle>();
            VisualMappingManager vmManager = (VisualMappingManager)CustomGraphicsManagerImpl.this.serviceRegistrar.getService(VisualMappingManager.class);
            block0: for (VisualStyle style : vmManager.getAllVisualStyles()) {
                block1: for (VisualProperty<?> vp : props) {
                    Object defValue = style.getDefaultValue(vp);
                    if (defValue != null && reloaded.contains(defValue)) {
                        updatedStyles.add(style);
                        continue block0;
                    }
                    if (this.canceled) {
                        return;
                    }
                    VisualMappingFunction fn = style.getVisualMappingFunction(vp);
                    if (fn instanceof PassthroughMapping) {
                        updatedStyles.add(style);
                        continue block0;
                    }
                    if (fn instanceof DiscreteMapping) {
                        DiscreteMapping dm = (DiscreteMapping)fn;
                        Map map = dm.getAll();
                        for (MissingImageCustomGraphics<?> mcg : reloaded) {
                            if (!map.containsValue(mcg)) continue;
                            updatedStyles.add(style);
                            continue block1;
                        }
                        continue;
                    }
                    if (!(fn instanceof ContinuousMapping)) continue;
                    ContinuousMapping cm = (ContinuousMapping)fn;
                    for (ContinuousMappingPoint point : cm.getAllPoints()) {
                        BoundaryRangeValues range = point.getRange();
                        if (!(range.equalValue != null && reloaded.contains(range.equalValue) || range.lesserValue != null && reloaded.contains(range.lesserValue)) && (range.greaterValue == null || !reloaded.contains(range.greaterValue))) continue;
                        updatedStyles.add(style);
                        continue block1;
                    }
                }
            }
            for (CyNetworkView networkView : this.networkViews) {
                if (this.canceled) {
                    return;
                }
                for (View nv : networkView.getNodeViews()) {
                    for (VisualProperty<?> vp : props) {
                        if (!nv.isDirectlyLocked(vp)) continue;
                        Object value = nv.getVisualProperty(vp);
                        if (this.canceled) {
                            return;
                        }
                        if (value == null || !reloaded.contains(value)) continue;
                        nv.setLockedValue(vp, value);
                    }
                }
                VisualStyle style = vmManager.getVisualStyle(networkView);
                if (!updatedStyles.contains(style)) continue;
                style.apply(networkView);
                networkView.updateView();
            }
        }
    }
}

