/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.image;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.cytoscape.cg.internal.image.MissingImageCustomGraphics;
import org.cytoscape.cg.internal.image.SVGCustomGraphicsFactory;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.cg.model.Taggable;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class MissingSVGCustomGraphics
extends SVGCustomGraphics
implements MissingImageCustomGraphics<SVGLayer> {
    private SVGCustomGraphics actualCustomGraphics;
    private final String serializationString;

    public MissingSVGCustomGraphics(String serializationString, Long id, String name, SVGCustomGraphicsFactory factory) throws IOException {
        super(id, name, DEF_IMAGE);
        this.serializationString = serializationString;
        this.factory = factory;
        this.fitRatio = 1.0f;
    }

    @Override
    public boolean isImageMissing() {
        return this.actualCustomGraphics == null;
    }

    public SVGCustomGraphics reloadImage() {
        CyCustomGraphics cg = this.factory.parseSerializableString(this.serializationString);
        if (cg instanceof SVGCustomGraphics && !(cg instanceof MissingSVGCustomGraphics)) {
            this.actualCustomGraphics = (SVGCustomGraphics)cg;
        }
        return this.actualCustomGraphics;
    }

    @Override
    public Long getIdentifier() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getIdentifier();
        }
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Long id) {
        if (this.actualCustomGraphics != null) {
            this.actualCustomGraphics.setIdentifier(id);
        }
        super.setIdentifier(id);
    }

    @Override
    public int getWidth() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getWidth();
        }
        return super.getWidth();
    }

    @Override
    public void setWidth(int width) {
        if (this.actualCustomGraphics != null) {
            this.actualCustomGraphics.setWidth(width);
        }
        super.setWidth(width);
    }

    @Override
    public int getHeight() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getHeight();
        }
        return super.getHeight();
    }

    @Override
    public void setHeight(int height) {
        if (this.actualCustomGraphics != null) {
            this.actualCustomGraphics.setHeight(height);
        }
        super.setHeight(height);
    }

    @Override
    public float getFitRatio() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getFitRatio();
        }
        return super.getFitRatio();
    }

    @Override
    public void setFitRatio(float fitRatio) {
        if (this.actualCustomGraphics != null) {
            this.actualCustomGraphics.setFitRatio(fitRatio);
        }
        super.setFitRatio(fitRatio);
    }

    @Override
    public String getDisplayName() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getDisplayName();
        }
        return super.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.actualCustomGraphics != null) {
            this.actualCustomGraphics.setDisplayName(displayName);
        }
        super.setDisplayName(displayName);
    }

    @Override
    public Collection<String> getTags() {
        if (this.actualCustomGraphics instanceof Taggable) {
            return this.actualCustomGraphics.getTags();
        }
        return super.getTags();
    }

    @Override
    public Image getRenderedImage() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getRenderedImage();
        }
        return super.getRenderedImage();
    }

    @Override
    public List<SVGLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> graphObject) {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.getLayers(networkView, graphObject);
        }
        return super.getLayers(networkView, graphObject);
    }

    public SVGCustomGraphics getActualCustomGraphics() {
        return this.actualCustomGraphics;
    }

    @Override
    public String toSerializableString() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.toSerializableString();
        }
        return super.toSerializableString();
    }

    @Override
    public String toString() {
        if (this.actualCustomGraphics != null) {
            return this.actualCustomGraphics.toString();
        }
        return super.toString();
    }
}

