/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.image;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.util.CustomGraphicsUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURLImageCustomGraphicsFactory<T extends CustomGraphicLayer>
implements CyCustomGraphicsFactory<T> {
    protected String[] entry;
    protected final CustomGraphicsManager manager;
    protected final CyServiceRegistrar serviceRegistrar;
    static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public AbstractURLImageCustomGraphicsFactory(CustomGraphicsManager manager, CyServiceRegistrar serviceRegistrar) {
        this.manager = manager;
        this.serviceRegistrar = serviceRegistrar;
    }

    public String getPrefix() {
        return "image";
    }

    public CyCustomGraphics<T> parseSerializableString(String entryStr) {
        long id;
        CyCustomGraphics<T> cg;
        if (entryStr == null) {
            return null;
        }
        if (!this.validate(entryStr)) {
            return null;
        }
        String imageId = this.entry[0];
        String sourceURL = this.entry[1];
        String imageName = CustomGraphicsUtil.getShortName(sourceURL);
        if (sourceURL != null) {
            try {
                URL url = new URL(sourceURL);
                CyCustomGraphics cg2 = this.manager.getCustomGraphicsBySourceURL(url);
                cg2.setDisplayName(imageName);
                return cg2;
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        if ((cg = this.manager.getCustomGraphicsByID(id = Long.parseLong(imageId))) == null) {
            cg = this.createMissingImageCustomGraphics(entryStr, id, sourceURL);
        }
        cg.setDisplayName(imageName);
        return cg;
    }

    public CyCustomGraphics<T> getInstance(URL url) {
        return this.getInstance(url.toString());
    }

    public Set<Class<? extends CyIdentifiable>> getSupportedTargetTypes() {
        return new HashSet<Class<? extends CyIdentifiable>>(Arrays.asList(CyNode.class, CyColumn.class));
    }

    protected abstract CyCustomGraphics<T> createMissingImageCustomGraphics(String var1, long var2, String var4);

    public abstract String getSupportedClassId();

    protected boolean validate(String entryStr) {
        this.entry = entryStr.split(",");
        return this.entry != null && this.entry.length >= 2;
    }
}

