/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.radial;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.cg.internal.gradient.AbstractGradientEditor;
import org.cytoscape.cg.internal.gradient.radial.RadialGradient;
import org.cytoscape.cg.internal.util.PointPicker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class RadialGradientEditor
extends AbstractGradientEditor<RadialGradient> {
    private JLabel centerLbl;
    private PointPicker pointPicker;

    public RadialGradientEditor(RadialGradient gradient, CyServiceRegistrar serviceRegistrar) {
        super(gradient, serviceRegistrar);
    }

    @Override
    protected JPanel getOtherOptionsPnl() {
        JPanel p = super.getOtherOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getCenterLbl()).addComponent(this.getPointPicker(), -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getCenterLbl()).addComponent(this.getPointPicker(), -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getCenterLbl()});
        return p;
    }

    private JLabel getCenterLbl() {
        if (this.centerLbl == null) {
            this.centerLbl = new JLabel("Center:");
        }
        return this.centerLbl;
    }

    private PointPicker getPointPicker() {
        if (this.pointPicker == null) {
            Point2D center = ((RadialGradient)this.gradient).get("cy_center", Point2D.class, new Point2D.Double(0.5, 0.5));
            this.pointPicker = new PointPicker(100, 12, center, this.serviceRegistrar);
            this.pointPicker.addPropertyChangeListener("value", evt -> {
                Point2D newCenter = (Point2D)evt.getNewValue();
                ((RadialGradient)this.gradient).set("cy_center", newCenter);
            });
        }
        return this.pointPicker;
    }

    @Override
    protected void update() {
        super.update();
        this.updatePointPicker();
    }

    private void updatePointPicker() {
        List<Float> fractions = ((RadialGradient)this.gradient).getList("cy_gradientFractions", Float.class);
        List<Color> colors = ((RadialGradient)this.gradient).getList("cy_gradientColors", Color.class);
        float[] fractionArr = new float[fractions.size()];
        int i = 0;
        for (Float f : fractions) {
            fractionArr[i++] = f.floatValue();
        }
        Color[] colorArr = colors.toArray(new Color[colors.size()]);
        this.getPointPicker().update(fractionArr, colorArr);
    }
}

