/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.linear;

import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.gradient.AbstractGradientEditor;
import org.cytoscape.cg.internal.gradient.linear.LinearGradient;
import org.cytoscape.cg.internal.util.AnglePicker;
import org.cytoscape.cg.internal.util.MathUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class LinearGradientEditor
extends AbstractGradientEditor<LinearGradient> {
    private static final long serialVersionUID = 5997072753907737888L;
    private JLabel angleLbl;
    private JComboBox<Integer> angleCmb;
    private AnglePicker anglePicker;
    private static Integer[] ANGLES = new Integer[]{0, 45, 90, 135, 180, 225, 270, 315};

    public LinearGradientEditor(LinearGradient gradient, CyServiceRegistrar serviceRegistrar) {
        super(gradient, serviceRegistrar);
    }

    @Override
    protected JPanel getOtherOptionsPnl() {
        JPanel p = super.getOtherOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGroup(layout.createSequentialGroup().addComponent(this.getAngleLbl()).addComponent(this.getAngleCmb(), -2, -1, -2)).addComponent(this.getAnglePicker(), -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getAngleLbl()).addComponent(this.getAngleCmb(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getAnglePicker(), -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.angleLbl, this.getAngleCmb()});
        return p;
    }

    public JLabel getAngleLbl() {
        if (this.angleLbl == null) {
            this.angleLbl = new JLabel("Angle (degrees):");
        }
        return this.angleLbl;
    }

    private JComboBox<Integer> getAngleCmb() {
        if (this.angleCmb == null) {
            this.angleCmb = new JComboBox<Integer>(ANGLES);
            this.angleCmb.setEditable(true);
            ((JLabel)((Object)this.angleCmb.getRenderer())).setHorizontalAlignment(4);
            this.angleCmb.setSelectedItem(Math.round((int)((LinearGradient)this.gradient).get("cy_angle", Double.class, 0.0).doubleValue()));
            this.angleCmb.setInputVerifier(new AbstractChartEditor.IntInputVerifier());
            this.angleCmb.addActionListener(e -> {
                Object angle = this.angleCmb.getSelectedItem();
                angle = angle instanceof Number ? ((Number)angle).intValue() : 0;
                ((LinearGradient)this.gradient).set("cy_angle", (int)Math.round(MathUtil.normalizeAngle(((Integer)angle).intValue())));
                this.updateAnglePicker();
            });
        }
        return this.angleCmb;
    }

    private AnglePicker getAnglePicker() {
        if (this.anglePicker == null) {
            this.anglePicker = new AnglePicker();
            this.anglePicker.setPreferredSize(new Dimension(120, 120));
            this.anglePicker.addPropertyChangeListener("value", evt -> {
                int angle = ((Number)evt.getNewValue()).intValue();
                this.getAngleCmb().setSelectedItem(angle);
            });
        }
        return this.anglePicker;
    }

    @Override
    protected void update() {
        super.update();
        this.updateAnglePicker();
    }

    private void updateAnglePicker() {
        List<Float> fractions = ((LinearGradient)this.gradient).getList("cy_gradientFractions", Float.class);
        List<Color> colors = ((LinearGradient)this.gradient).getList("cy_gradientColors", Color.class);
        Double angle = ((LinearGradient)this.gradient).get("cy_angle", Double.class, 0.0);
        float[] fractionArr = new float[fractions.size()];
        int i = 0;
        for (Float f : fractions) {
            fractionArr[i++] = f.floatValue();
        }
        Color[] colorArr = colors.toArray(new Color[colors.size()]);
        this.getAnglePicker().update(fractionArr, colorArr, (int)Math.round(angle));
    }
}

