/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient;

import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.cytoscape.cg.internal.util.ColorUtil;
import org.cytoscape.cg.internal.util.GradientEditor;
import org.cytoscape.cg.internal.util.ViewUtil;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.cytoscape.cg.model.ColorScheme;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public abstract class AbstractGradientEditor<T extends AbstractCustomGraphics2<?>>
extends JPanel {
    private JPanel colorsPnl;
    private JButton paletteBtn;
    private JButton reverseBtn;
    private GradientEditor grEditor;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton editBtn;
    private JPanel otherOptionsPnl;
    private Palette lastPalette;
    private Palette currentPalette;
    private PaletteType paletteType;
    protected final T gradient;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractGradientEditor(T gradient, CyServiceRegistrar serviceRegistrar) {
        this.gradient = gradient;
        this.serviceRegistrar = serviceRegistrar;
        this.paletteType = BrewerType.ANY;
        this.lastPalette = this.retrievePalette();
        this.setCurrentPalette(this.lastPalette);
        this.init();
    }

    protected void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getColorsPnl(), -2, 320, -2).addComponent(this.getOtherOptionsPnl())).addGap(0, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getColorsPnl(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getOtherOptionsPnl()));
        JComponent[] buttons = new JButton[]{this.getPaletteBtn(), this.getReverseBtn(), this.getAddBtn(), this.getRemoveBtn(), this.getEditBtn()};
        ViewUtil.styleEditorButtons((AbstractButton[])buttons);
        LookAndFeelUtil.equalizeSize((JComponent[])buttons);
        this.setMaximumSize(new Dimension(350, this.getPreferredSize().height));
        this.update();
    }

    private JPanel getColorsPnl() {
        if (this.colorsPnl == null) {
            this.colorsPnl = new JPanel();
            this.colorsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.colorsPnl);
            this.colorsPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGap(5).addComponent(this.getPaletteBtn()).addGap(10, 10, Short.MAX_VALUE).addComponent(this.getReverseBtn()).addGap(5)).addComponent(this.getGrEditor(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.getAddBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getRemoveBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getEditBtn())));
            layout.setVerticalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getPaletteBtn(), -2, -1, -2).addComponent(this.getReverseBtn(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getGrEditor(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getAddBtn(), -2, -1, -2).addComponent(this.getRemoveBtn(), -2, -1, -2).addComponent(this.getEditBtn(), -2, -1, -2)));
        }
        return this.colorsPnl;
    }

    private JButton getPaletteBtn() {
        if (this.paletteBtn == null) {
            this.paletteBtn = new JButton("Palette");
            this.paletteBtn.addActionListener(evt -> {
                CyColorPaletteChooserFactory factory = (CyColorPaletteChooserFactory)this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
                CyColorPaletteChooser chooser = factory.getColorPaletteChooser(this.paletteType, false);
                Palette newPalette = chooser.showDialog((Component)this, "Set Palette", this.currentPalette, 9);
                if (newPalette != null) {
                    this.setCurrentPalette(newPalette);
                    List<Color> colorList = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientColors", Color.class);
                    Color[] colors = newPalette.getColors(colorList.size());
                    this.setColors(colors);
                }
            });
        }
        return this.paletteBtn;
    }

    public JButton getReverseBtn() {
        if (this.reverseBtn == null) {
            this.reverseBtn = new JButton("\uf0ec");
            this.reverseBtn.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
            this.reverseBtn.setToolTipText("Reverse Colors");
            this.reverseBtn.addActionListener(evt -> this.reverseColors());
        }
        return this.reverseBtn;
    }

    protected GradientEditor getGrEditor() {
        if (this.grEditor == null) {
            List<Float> fractions = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientFractions", Float.class);
            List<Color> colors = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientColors", Color.class);
            this.grEditor = new GradientEditor(fractions, colors, this.serviceRegistrar);
            this.grEditor.addActionListener(e -> this.onGradientUpdated());
            this.grEditor.addPropertyChangeListener("selected", evt -> this.update());
            if (fractions == null || fractions.size() < 2) {
                this.onGradientUpdated();
            }
        }
        return this.grEditor;
    }

    private JButton getAddBtn() {
        if (this.addBtn == null) {
            IconManager icoMgr = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.addBtn = new JButton();
            this.addBtn.setIcon((Icon)new TextIcon("\uf067", icoMgr.getIconFont(14.0f), 16, 16));
            this.addBtn.setToolTipText("Add Color");
            this.addBtn.addActionListener(evt -> this.getGrEditor().addPoint());
        }
        return this.addBtn;
    }

    private JButton getRemoveBtn() {
        if (this.removeBtn == null) {
            IconManager icoMgr = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.removeBtn = new JButton();
            this.removeBtn.setIcon((Icon)new TextIcon("\uf014", icoMgr.getIconFont(16.0f), 16, 16));
            this.removeBtn.setToolTipText("Remove Color");
            this.removeBtn.setEnabled(false);
            this.removeBtn.addActionListener(evt -> this.getGrEditor().deletePoint());
        }
        return this.removeBtn;
    }

    private JButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = new JButton();
            this.editBtn.setIcon(new ColorIcon(16, 16));
            this.editBtn.setToolTipText("Edit Color");
            this.editBtn.setEnabled(false);
            this.editBtn.addActionListener(evt -> this.getGrEditor().editPoint());
        }
        return this.editBtn;
    }

    protected JPanel getOtherOptionsPnl() {
        if (this.otherOptionsPnl == null) {
            this.otherOptionsPnl = new JPanel();
            this.otherOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.otherOptionsPnl.setVisible(false);
        }
        return this.otherOptionsPnl;
    }

    private Palette retrievePalette() {
        ColorScheme scheme = ((AbstractCustomGraphics2)this.gradient).get("cy_colorScheme", ColorScheme.class);
        return scheme != null ? scheme.getPalette() : null;
    }

    private void setCurrentPalette(Palette palette) {
        this.getPaletteBtn().setToolTipText(palette != null ? palette.toString() : "None");
        this.currentPalette = palette;
    }

    private void setColors(Color[] colors) {
        ArrayList<GradientEditor.ControlPoint> controlPoints = new ArrayList<GradientEditor.ControlPoint>();
        List<Float> fractions = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientFractions", Float.class);
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            float f = fractions.get(i).floatValue();
            controlPoints.add(new GradientEditor.ControlPoint(c, f));
        }
        this.grEditor.setPoints(controlPoints);
    }

    private void reverseColors() {
        List<Float> fractions = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientFractions", Float.class);
        List<Color> colors = ((AbstractCustomGraphics2)this.gradient).getList("cy_gradientColors", Color.class);
        ArrayList<GradientEditor.ControlPoint> controlPoints = new ArrayList<GradientEditor.ControlPoint>();
        for (int i = fractions.size() - 1; i >= 0; --i) {
            float f = fractions.get(i).floatValue();
            Color c = colors.get(i);
            f = 1.0f - f;
            f = Math.max(0.0f, Math.min(1.0f, f));
            controlPoints.add(new GradientEditor.ControlPoint(c, f));
        }
        this.grEditor.setPoints(controlPoints);
    }

    private void onGradientUpdated() {
        ((AbstractCustomGraphics2)this.gradient).set("cy_gradientFractions", this.getGrEditor().getPositions());
        ((AbstractCustomGraphics2)this.gradient).set("cy_gradientColors", this.getGrEditor().getColors());
        if (this.currentPalette != null) {
            ColorScheme newScheme = new ColorScheme(this.currentPalette);
            ((AbstractCustomGraphics2)this.gradient).set("cy_colorScheme", newScheme);
        }
        this.update();
    }

    protected void update() {
        this.updatePointButtons();
    }

    private void updatePointButtons() {
        GradientEditor.ControlPoint selected = this.getGrEditor().getSelected();
        List<GradientEditor.ControlPoint> controlPoints = this.getGrEditor().getControlPoints();
        ((ColorIcon)this.getEditBtn().getIcon()).setColor(selected != null ? selected.getColor() : null);
        this.getEditBtn().setEnabled(selected != null);
        this.getRemoveBtn().setEnabled(selected != null && !Objects.equal((Object)selected, (Object)controlPoints.get(0)) && !Objects.equal((Object)selected, (Object)controlPoints.get(controlPoints.size() - 1)));
    }

    private class ColorIcon
    implements Icon {
        private Color color;
        private final int width;
        private final int height;

        public ColorIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconHeight() {
            return this.width;
        }

        @Override
        public int getIconWidth() {
            return this.height;
        }

        public void setColor(Color color) {
            this.color = color;
            AbstractGradientEditor.this.repaint();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (c.isEnabled()) {
                g.setColor(this.color != null ? this.color : Color.WHITE);
                g.fillRect(x, y, w, h);
            }
            g.setColor(c.isEnabled() ? ColorUtil.getContrastingColor(c.getBackground()) : UIManager.getColor("Button.disabledForeground"));
            g.drawRect(x, y, w, h);
            if (this.color == null && c.isEnabled()) {
                g.setColor(Color.RED);
                g.drawLine(x + 1, y + h - 1, x + w - 1, y + 1);
            }
        }
    }
}

